/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.sql.CommitsIndex;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUtils {
    private static final Logger log = LoggerFactory.getLogger(SqlUtils.class);

    public static <T> Stream<T> streamRows(Function<ResultSet, T> conv, ResultSet resultSet) {
        try {
            LinkedList<T> result = new LinkedList<T>();
            while (resultSet.next()) {
                result.add(conv.apply(resultSet));
            }
            return result.stream();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<Map.Entry<String, String>> streamFields(ResultSet rs) {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            LinkedList<AbstractMap.SimpleEntry<String, String>> all = new LinkedList<AbstractMap.SimpleEntry<String, String>>();
            for (int i = 1; i <= columnCount; ++i) {
                String name = rsmd.getColumnName(i);
                all.add(new AbstractMap.SimpleEntry<String, String>(name, rs.getString(name)));
            }
            return all.stream();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static int merge(Connection con, String tableAlias, String ... values) {
        int n;
        block11: {
            int length = values.length / 2;
            StringJoiner joiner = new StringJoiner(",");
            for (int i = 1; i < length; ++i) {
                String s = String.format(" %s = incoming.%s", SqlUtils.escapeFormat(values[i]), SqlUtils.escapeFormat(values[i]));
                joiner.add(s);
            }
            LinkedList<String> wds = new LinkedList<String>();
            for (int i = 0; i < length; ++i) {
                wds.add(values[i].contains("FORMAT JSON") ? "? FORMAT JSON" : "?");
            }
            String sql = "MERGE    into $table\nUSING    values ($values) as incoming($fields)\nON       $table.$conflictField = incoming.$conflictField\nWHEN not matched then\nINSERT\n    ($fields)\n    values\n    ($Inc.fields)\nWHEN     matched then\nUPDATE\nSET\n    $sets;\n".replace("$table", tableAlias).replace("$values", String.join((CharSequence)",", wds)).replace("$fields", ((Stream)Arrays.stream(values).sequential()).map(SqlUtils::escapeFormat).limit(length).collect(Collectors.joining(","))).replace("$Inc.fields", ((Stream)Arrays.stream(values).sequential()).map(SqlUtils::escapeFormat).limit(length).map(cF -> "incoming." + cF).collect(Collectors.joining(","))).replace("$conflictField", SqlUtils.escapeFormat(values[0])).replace("$sets", joiner.toString());
            PreparedStatement statement = con.prepareStatement(sql);
            try {
                StringBuilder s = new StringBuilder(sql);
                for (int i = 0; i < length; ++i) {
                    int parameterIndex = i + 1;
                    String value = SqlUtils.escapeFormat(values[i + length]);
                    statement.setString(parameterIndex, value);
                    s.append(parameterIndex).append(" = ").append(value).append(System.lineSeparator());
                }
                log.debug(CommitsIndex.renderSqlLog(s.toString()));
                n = statement.executeUpdate();
                if (statement == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            statement.close();
        }
        return n;
    }

    public static int merge(Connection con, String tableAlias, List<String> mergeColumns, Map<String, String> values) {
        int n;
        block11: {
            int length = values.size();
            StringJoiner joiner = new StringJoiner(",");
            List columns = values.keySet().stream().toList();
            for (int i = 0; i < length; ++i) {
                if (mergeColumns.contains(SqlUtils.escapeFormat((String)columns.get(i))) || mergeColumns.contains(columns.get(i))) continue;
                String s = String.format(" %s = incoming.%s", SqlUtils.escapeFormat((String)columns.get(i)), SqlUtils.escapeFormat((String)columns.get(i)));
                joiner.add(s);
            }
            LinkedList<String> wds = new LinkedList<String>();
            for (int i = 0; i < length; ++i) {
                wds.add(((String)columns.get(i)).contains("FORMAT JSON") ? "? FORMAT JSON" : "?");
            }
            String sql = "MERGE    into $table\nUSING    values ($values) as incoming($fields)\nON       $conflicts\nWHEN not matched then\nINSERT\n    ($fields)\n    values\n    ($Inc.fields)\nWHEN     matched then\nUPDATE\nSET\n    $sets;\n".replace("$table", tableAlias).replace("$values", String.join((CharSequence)",", wds)).replace("$fields", columns.stream().map(SqlUtils::escapeFormat).collect(Collectors.joining(","))).replace("$Inc.fields", columns.stream().map(SqlUtils::escapeFormat).map(cF -> "incoming." + cF).collect(Collectors.joining(","))).replace("$conflictField", SqlUtils.escapeFormat(mergeColumns.get(0))).replace("$conflicts", mergeColumns.stream().map(col -> "$table.$conflictField = incoming.$conflictField".replace("$table", tableAlias).replace("$conflictField", (CharSequence)col)).collect(Collectors.joining(" AND "))).replace("$sets", joiner.toString());
            PreparedStatement statement = con.prepareStatement(sql);
            try {
                StringBuilder s = new StringBuilder(sql);
                for (int i = 0; i < length; ++i) {
                    int parameterIndex = i + 1;
                    String value = SqlUtils.escapeFormat(values.get(columns.get(i)));
                    statement.setString(parameterIndex, value);
                    s.append(parameterIndex).append(" = ").append(value).append(System.lineSeparator());
                }
                log.debug(CommitsIndex.renderSqlLog(s.toString()));
                n = statement.executeUpdate();
                if (statement == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            statement.close();
        }
        return n;
    }

    private static String escapeFormat(String values) {
        return values.replace(" FORMAT JSON", "");
    }

    public static ResultSet query(Connection con, String sql, String ... values) {
        PreparedStatement statement = null;
        try {
            statement = con.prepareStatement(sql);
            log.debug(CommitsIndex.renderSqlLog(sql));
            for (int i = 0; i < values.length; ++i) {
                statement.setString(i + 1, values[i]);
            }
            return statement.executeQuery();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static int queryUpdate(Connection con, String sql, String ... values) {
        int n;
        block9: {
            PreparedStatement statement = con.prepareStatement(sql);
            try {
                log.debug(CommitsIndex.renderSqlLog(sql));
                for (int i = 0; i < values.length; ++i) {
                    statement.setString(i + 1, values[i]);
                }
                n = statement.executeUpdate();
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            statement.close();
        }
        return n;
    }

    public static StringBuilder renderSchema(String tableName, List<String> aliases) {
        StringBuilder sql1 = new StringBuilder(String.format("CREATE TABLE IF NOT EXISTS %s\n(\nts_ID INT auto_increment,\n", tableName));
        for (int i = 0; i < aliases.size(); ++i) {
            sql1.append(aliases.get(i)).append(" VARCHAR(256) ");
            if (i + 1 < aliases.size()) {
                sql1.append(", \n");
                continue;
            }
            sql1.append(" \n");
        }
        sql1.append(");");
        return sql1;
    }

    public static class SchemaBuilder {
        private final String alias;
        private final Map<String, Optional<String>> columns;
        private final List<String> indexes;
        private final List<String> mergeColumns;

        public SchemaBuilder(String alias) {
            this.alias = alias;
            this.indexes = new ArrayList<String>();
            this.columns = new HashMap<String, Optional<String>>();
            this.mergeColumns = new LinkedList<String>();
        }

        public SchemaBuilder withColumn(String columnAlias) {
            this.columns.put(columnAlias, Optional.empty());
            return this;
        }

        public SchemaBuilder withColumn(String columnAlias, String overr) {
            this.columns.put(columnAlias, Optional.of(overr));
            return this;
        }

        public SchemaBuilder withIndex(String index) {
            this.indexes.add(index);
            return this;
        }

        public SchemaBuilder withMerge(String ... columnAliases) {
            this.mergeColumns.addAll(List.of(columnAliases));
            return this;
        }

        public String toDML() {
            StringBuilder sql1 = new StringBuilder(String.format("CREATE TABLE IF NOT EXISTS %s\n(\nID INT auto_increment", this.alias));
            this.columns.forEach((k, v) -> {
                sql1.append(",\n");
                if (v.isPresent()) {
                    sql1.append((String)v.get());
                } else {
                    sql1.append((String)k);
                    sql1.append(" VARCHAR(512)");
                }
            });
            this.indexes.forEach(cIndex -> {
                sql1.append(",\n");
                sql1.append((String)cIndex);
            });
            sql1.append(");");
            return sql1.toString();
        }

        public String getAlias() {
            return this.alias;
        }

        public Map<String, Optional<String>> getColumns() {
            return this.columns;
        }

        public List<String> getIndexes() {
            return this.indexes;
        }

        public List<String> getMergeColumns() {
            return this.mergeColumns;
        }
    }

    public static class FieldSource {
        private final String alias;

        FieldSource(String alias) {
            this.alias = alias;
        }

        public static FieldSourceBuilder builder() {
            return new FieldSourceBuilder();
        }

        public String getAlias() {
            return this.alias;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldSource)) {
                return false;
            }
            FieldSource other = (FieldSource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$alias = this.getAlias();
            String other$alias = other.getAlias();
            return !(this$alias == null ? other$alias != null : !this$alias.equals(other$alias));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FieldSource;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
            return result;
        }

        public String toString() {
            return "SqlUtils.FieldSource(alias=" + this.getAlias() + ")";
        }

        public static class FieldSourceBuilder {
            private String alias;

            FieldSourceBuilder() {
            }

            public FieldSourceBuilder alias(String alias) {
                this.alias = alias;
                return this;
            }

            public FieldSource build() {
                return new FieldSource(this.alias);
            }

            public String toString() {
                return "SqlUtils.FieldSource.FieldSourceBuilder(alias=" + this.alias + ")";
            }
        }
    }
}

