package io.github.zebin.javabash.frontend;

import io.github.zebin.javabash.frontend.brush.TerminalPalette;
import io.github.zebin.javabash.frontend.brush.TextBrush;
import io.github.zebin.javabash.frontend.brush.TextShrink;
import lombok.Builder;
import lombok.Data;
import lombok.With;

import java.util.function.Function;

@Builder
@Data
@With
public class FunnyTerminalConfigs {

    public static final FunnyTerminalConfigs DEFAULT = getDefault();

    public static FunnyTerminalConfigs getDefault() {
        FunnyTerminal.ColorPool defaults = FunnyTerminal.ColorPool.defaults();
        FunnyTerminal.ColorPool defaults2 = FunnyTerminal.ColorPool.defaults();
        return builder()
                .dir(
                        s -> new TextBrush(TextShrink.getShrinkDir(s, 30))
                                .fill(defaults2.getColor(TextShrink.getShrinkDir(s, 30)))
                                .toString()
                )
                .stderr(s -> FunnyTerminalPresets.stdErrRender(new TextBrush(s)).toString())
                .stdout(s -> FunnyTerminalPresets.stdRender(new TextBrush(s)).toString())
                .stdin(s -> s)
                .id(s -> new TextBrush(s).fill(defaults.getColor(s)).toString())
                .cmd(FunnyTerminalPresets::bashRender)
                .user(s -> new TextBrush(s).fill(TerminalPalette.MAGENTA).toString())
                .build();
    }

    @Builder.Default
    private Function<String, String> stderr = s -> s;
    @Builder.Default
    private Function<String, String> stdout = s -> s;
    @Builder.Default
    private Function<String, String> stdin = s -> s;
    @Builder.Default
    private Function<String, String> user = s -> s;
    @Builder.Default
    private Function<String, String> dir = s -> s;
    @Builder.Default
    private Function<String, String> id = s -> s;
    @Builder.Default
    private Function<String, String> cmd = s -> s;
}
