/*
 * Decompiled with CFR 0.152.
 */
package io.github.zebin.javabash.sandbox;

import io.github.zebin.javabash.sandbox.PosixPath;
import java.io.Reader;
import java.io.Writer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public interface DirectoryTree {
    default public void validate(PosixPath path) {
        if (path.isAbsolute()) {
            throw new IllegalArgumentException(String.format("Invalid path %s, must use relative only", path));
        }
    }

    public Writer put(PosixPath var1);

    public boolean delete(PosixPath var1);

    public Writer patch(PosixPath var1);

    public Reader get(PosixPath var1);

    public boolean exists(PosixPath var1);

    public boolean isDir(PosixPath var1);

    public Stream<PosixPath> list(PosixPath var1);

    default public <T> T setupDir(Supplier<T> result) {
        return result.get();
    }

    default public void traverse(PosixPath start, Function<PosixPath, Boolean> sayEnter) {
        this.list(start).filter(this::isDir).filter(sayEnter::apply).forEach(f -> this.traverse((PosixPath)f, sayEnter));
    }
}

