/*
 * Decompiled with CFR 0.152.
 */
package io.github.zebin.javabash.frontend.brush;

import io.github.zebin.javabash.frontend.brush.TerminalPalette;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class TextBrush {
    private List<ColouredBlock> blocks;

    public TextBrush(String s) {
        this.blocks = new LinkedList<ColouredBlock>(List.of(new ColouredBlock(s, null)));
    }

    public TextBrush paint(String word, Object c) {
        this.blocks = this.blocks.stream().filter(cW -> !cW.getText().isEmpty()).flatMap(cWord -> {
            List<ColouredBlock> colouredWords = TextBrush.joinWithWord(Stream.of((cWord.getText() + " ").split(word)).map(f -> new ColouredBlock((String)f, cWord.getColor())), new ColouredBlock(word, c));
            if (!colouredWords.isEmpty()) {
                ColouredBlock last = TextBrush.lastOf(colouredWords);
                last.setText(last.getText().substring(0, last.getText().length() - 1));
            }
            if ((colouredWords = colouredWords.stream().filter(cW -> !cW.getText().isEmpty()).toList()).isEmpty()) {
                return Stream.of(new ColouredBlock(word, c));
            }
            return colouredWords.stream();
        }).collect(Collectors.toList());
        return this;
    }

    private static ColouredBlock lastOf(List<ColouredBlock> colouredWords) {
        return colouredWords.get(colouredWords.size() - 1);
    }

    public TextBrush fill(Object c) {
        this.blocks.forEach(cBlock -> cBlock.setColor(c));
        return this;
    }

    public TextBrush fillSurrounding(String word, Object c) {
        this.blocks = this.blocks.stream().filter(cW -> !cW.getText().isEmpty()).flatMap(cWord -> {
            Stream<ColouredBlock> wordStream = Stream.of((cWord.getText() + " ").split(word)).map(f -> new ColouredBlock((String)f, cWord.getColor()));
            List<ColouredBlock> colouredWords = TextBrush.joinWithWord(wordStream, new ColouredBlock(word, cWord.getColor()));
            ColouredBlock last = TextBrush.lastOf(colouredWords);
            last.setText(last.getText().substring(0, last.getText().length() - 1));
            boolean start = false;
            for (ColouredBlock cw : colouredWords) {
                if (start && cw.getText().equals(word)) {
                    start = false;
                    continue;
                }
                if (start) {
                    cw.setColor(c);
                    continue;
                }
                if (!cw.getText().equals(word)) continue;
                start = true;
            }
            return colouredWords.stream();
        }).filter(cW -> !cW.getText().isEmpty()).collect(Collectors.toList());
        return this;
    }

    public static List<ColouredBlock> joinWithWord(Stream<ColouredBlock> bashTMLWordStream, ColouredBlock e) {
        return bashTMLWordStream.reduce(new LinkedList(), (a, b) -> {
            LinkedList<ColouredBlock> bashTMLWords = new LinkedList<ColouredBlock>((Collection<ColouredBlock>)a);
            if (!bashTMLWords.isEmpty()) {
                bashTMLWords.add(e);
            }
            bashTMLWords.add((ColouredBlock)b);
            return bashTMLWords;
        }, (a, b) -> {
            LinkedList<ColouredBlock> objects = new LinkedList<ColouredBlock>((Collection<ColouredBlock>)a);
            if (!a.isEmpty() && !b.isEmpty()) {
                objects.add(e);
            }
            objects.addAll((Collection<ColouredBlock>)b);
            return objects;
        });
    }

    public String toString() {
        return this.blocks.stream().map(cWord -> cWord.getColor() != null ? String.valueOf(cWord.getColor()) + cWord.getText() + String.valueOf((Object)TerminalPalette.RESET) : cWord.getText()).collect(Collectors.joining());
    }

    public static class ColouredBlock {
        private String text;
        private Object color;

        @Generated
        public ColouredBlock(String text, Object color) {
            this.text = text;
            this.color = color;
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public Object getColor() {
            return this.color;
        }

        @Generated
        public void setText(String text) {
            this.text = text;
        }

        @Generated
        public void setColor(Object color) {
            this.color = color;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColouredBlock)) {
                return false;
            }
            ColouredBlock other = (ColouredBlock)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            Object this$color = this.getColor();
            Object other$color = other.getColor();
            return !(this$color == null ? other$color != null : !this$color.equals(other$color));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ColouredBlock;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            Object $color = this.getColor();
            result = result * 59 + ($color == null ? 43 : $color.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TextBrush.ColouredBlock(text=" + this.getText() + ", color=" + String.valueOf(this.getColor()) + ")";
        }
    }
}

