/*
 * Decompiled with CFR 0.152.
 */
package io.github.zebin.javabash.process;

import io.github.zebin.javabash.frontend.FunnyTerminal;
import io.github.zebin.javabash.process.TextTerminal;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalProcess
implements TextTerminal {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TerminalProcess.class);
    private final Process process;
    private final byte[] buffer = new byte[4000];
    private final PrintWriter pw;
    private final String fin = UUID.randomUUID().toString().substring(0, 8);
    private long timeoutMillis = 1800000L;

    public TerminalProcess(Process process) {
        this.process = process;
        this.pw = new PrintWriter(process.getOutputStream());
        this.pw.println(String.format("fu=%s ; fu+=%s ; echo $fu", this.fin.substring(0, 4), this.fin.substring(4, 8)));
        this.execute(process, this.buffer, this.fin, ff -> {}, ff -> {});
    }

    public void setTimeoutMillis(long timeout) {
        this.timeoutMillis = timeout;
    }

    @Override
    public int exec(String comm, String mask, Consumer<String> stdout, Consumer<String> stderr) {
        StringBuilder ret = new StringBuilder();
        StringBuilder err = new StringBuilder();
        this.pw.println(comm);
        this.pw.println("return=$?");
        this.pw.println("echo $fu");
        this.execute(this.process, this.buffer, this.fin, stdout, stderr);
        this.pw.println("echo $return");
        this.pw.println("echo $fu");
        this.execute(this.process, this.buffer, this.fin, ret::append, err::append);
        return Integer.parseInt(ret.toString().lines().collect(Collectors.joining()));
    }

    private void execute(Process process, byte[] buffer, String fin, Consumer<String> wr, Consumer<String> stderr) {
        long start = System.currentTimeMillis();
        this.pw.flush();
        InputStream out = process.getInputStream();
        InputStream err = process.getErrorStream();
        AtomicBoolean writtenOut = new AtomicBoolean();
        AtomicBoolean writtenErr = new AtomicBoolean();
        int matched = 0;
        boolean isFinished = false;
        try {
            while (this.isAlive(process) && !isFinished) {
                log.trace("Process alive...");
                writtenOut.set(true);
                writtenErr.set(true);
                while (writtenOut.get() || writtenErr.get()) {
                    if (System.currentTimeMillis() - start > this.timeoutMillis) {
                        throw new RuntimeException("Failed execution, because of timeout!");
                    }
                    writtenOut.set(false);
                    writtenErr.set(false);
                    log.trace("Pulling stdout...");
                    matched = this.pull(buffer, fin, FunnyTerminal.fork(wr, fu -> writtenOut.set(true)), out, matched);
                    log.trace("Pulling stderr...");
                    TerminalProcess.pullErr(buffer, FunnyTerminal.fork(stderr, fu -> writtenErr.set(true)), err);
                    if (matched != fin.length()) continue;
                    isFinished = true;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int pull(byte[] buffer, String fin, Consumer<String> wr, InputStream out, int matched) throws IOException {
        int no = out.available();
        log.trace("Available {} bytes", (Object)no);
        if (no > 0) {
            int n = out.read(buffer, 0, Math.min(no, buffer.length));
            log.trace("Read {} bytes", (Object)n);
            String bufSeg = new String(buffer, 0, n);
            for (int i = 0; i < bufSeg.length(); ++i) {
                char cChar;
                char toFind = fin.charAt(matched);
                if (toFind == (cChar = bufSeg.charAt(i))) {
                    if (++matched != fin.length()) continue;
                    break;
                }
                wr.accept(fin.substring(0, matched));
                wr.accept(String.valueOf(cChar));
                matched = 0;
            }
        }
        return matched;
    }

    private static void pullErr(byte[] buffer, Consumer<String> wr, InputStream out) throws IOException {
        int no = out.available();
        if (no > 0) {
            int n = out.read(buffer, 0, Math.min(no, buffer.length));
            String bufSeg = new String(buffer, 0, n);
            wr.accept(bufSeg);
        }
    }

    private boolean isAlive(Process p) {
        try {
            p.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }
}

