/*
 * Decompiled with CFR 0.152.
 */
package io.github.zebin.javabash.sandbox;

import io.github.zebin.javabash.process.TextTerminal;
import io.github.zebin.javabash.sandbox.PosixPath;
import java.util.List;
import java.util.stream.Collectors;

public class FileManager {
    private final TextTerminal delegate;

    public FileManager(TextTerminal delegate) {
        this.delegate = delegate;
    }

    public PosixPath getCurrent() {
        return PosixPath.ofPosix(this.delegate.eval("pwd"));
    }

    public PosixPath goUp() {
        return this.go(PosixPath.LEVEL_UP);
    }

    public PosixPath go(PosixPath path) {
        this.delegate.eval(String.format("cd %s", path));
        return this.getCurrent();
    }

    public String read(PosixPath pp) {
        return this.delegate.eval(String.format("cat %s", pp));
    }

    public PosixPath makeFile(PosixPath newDir) {
        this.delegate.eval(String.format("touch %s", newDir));
        return newDir.isAbsolute() ? newDir : this.getCurrent().climb(newDir);
    }

    public List<PosixPath> list() {
        return this.list(this.getCurrent());
    }

    public List<PosixPath> list(PosixPath path) {
        String eval = this.delegate.eval(String.format("ls -a %s", path));
        return eval.lines().map(PosixPath::ofPosix).collect(Collectors.toList());
    }

    public PosixPath makeDir(PosixPath newDir) {
        this.delegate.eval(String.format("mkdir %s", newDir));
        return newDir.isAbsolute() ? newDir : this.getCurrent().climb(newDir);
    }

    public boolean dirExists(PosixPath newDir) {
        return this.delegate.eval(String.format("if [ -d %s ]; then echo \"YES\"; else echo \"NO\"; fi", newDir)).contains("YES");
    }

    public boolean exists(PosixPath path) {
        return this.fileExists(path) || this.dirExists(path);
    }

    public boolean fileExists(PosixPath newDir) {
        return this.delegate.eval(String.format("if [ -f %s ]; then echo \"YES\"; else echo \"NO\"; fi", newDir)).contains("YES");
    }

    public boolean isFolder(PosixPath newDir) {
        return this.dirExists(newDir);
    }

    public boolean isFile(PosixPath newDir) {
        return this.exists(newDir) && !this.isFolder(newDir);
    }

    public PosixPath removeDir(PosixPath newDir) {
        this.delegate.eval(String.format("rm -rf %s", newDir));
        return newDir.isAbsolute() ? newDir : this.getCurrent().climb(newDir);
    }

    public PosixPath remove(PosixPath path) {
        if (!this.exists(path)) {
            throw new IllegalArgumentException(String.format("Cannot remove, because object is missing %s", path));
        }
        if (this.isFolder(path)) {
            return this.removeDir(path);
        }
        if (this.isFile(path)) {
            return this.removeFile(path);
        }
        throw new IllegalArgumentException(String.format("Unknown object %s", path));
    }

    public PosixPath removeFile(PosixPath newDir) {
        if (this.isFolder(newDir)) {
            throw new IllegalArgumentException(String.format("Wanted to remove file %s, while actually it is a folder!", newDir));
        }
        this.delegate.eval(String.format("rm %s", newDir));
        return newDir.isAbsolute() ? newDir : this.getCurrent().climb(newDir);
    }
}

