/*
 * Decompiled with CFR 0.152.
 */
package io.github.zebin.javabash.sandbox;

import io.github.zebin.javabash.sandbox.PosixPath;
import java.io.Reader;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public interface DirectoryTree {
    default public void validate(PosixPath path) {
        if (path.isAbsolute()) {
            throw new IllegalArgumentException(String.format("Invalid path %s, must use relative only", path));
        }
    }

    public Writer put(PosixPath var1);

    public boolean delete(PosixPath var1);

    public Writer patch(PosixPath var1);

    public Reader get(PosixPath var1);

    public boolean exists(PosixPath var1);

    public boolean isDir(PosixPath var1);

    public int run(String var1, Consumer<String> var2, Consumer<String> var3);

    public Stream<PosixPath> list(PosixPath var1);

    default public void traverse(PosixPath start, Function<PosixPath, Boolean> sayEnter, Function<PosixPath, Boolean> sayBreak) {
        AtomicBoolean nextTime = new AtomicBoolean(true);
        this.list(start).filter(this::isDir).takeWhile(t -> {
            boolean thisTime = nextTime.get();
            nextTime.set((Boolean)sayBreak.apply((PosixPath)t) == false);
            return thisTime;
        }).filter(sayEnter::apply).forEach(f -> this.traverse((PosixPath)f, sayEnter, sayBreak));
    }
}

