/*
 * Decompiled with CFR 0.152.
 */
package io.github.zebin.javabash.sandbox;

import io.github.zebin.javabash.process.TextTerminal;
import io.github.zebin.javabash.sandbox.BashUtils;
import io.github.zebin.javabash.sandbox.PosixPath;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileManager.class);
    private final TextTerminal delegate;

    public FileManager(TextTerminal delegate) {
        this.delegate = delegate;
    }

    public PosixPath getCurrent() {
        return PosixPath.ofPosix(this.delegate.eval("pwd"));
    }

    public PosixPath goUp() {
        return this.go(PosixPath.LEVEL_UP);
    }

    public PosixPath go(PosixPath path) {
        this.delegate.eval(String.format("cd %s", path));
        return this.getCurrent();
    }

    public int run(String comm, Consumer<String> stdout, Consumer<String> stderr) {
        return this.delegate.exec(comm, stdout, stderr);
    }

    public String read(PosixPath pp) {
        return this.delegate.eval(String.format("cat %s", pp));
    }

    public Writer write(final PosixPath pp) {
        return new StringWriter(){

            @Override
            public void close() throws IOException {
                FileManager.this.delegate.eval(String.format("echo %s > %s", BashUtils.escape(this.toString()), pp));
                super.close();
            }
        };
    }

    public Writer append(final PosixPath pp) {
        return new StringWriter(){

            @Override
            public void close() throws IOException {
                FileManager.this.delegate.eval(String.format("echo %s >> %s", BashUtils.escape(this.toString()), pp));
                super.close();
            }
        };
    }

    public PosixPath makeFile(PosixPath newDir) {
        this.delegate.eval(String.format("touch %s", newDir));
        return newDir.isAbsolute() ? newDir : this.getCurrent().climb(newDir);
    }

    public List<PosixPath> list() {
        return this.list(this.getCurrent());
    }

    public List<PosixPath> list(PosixPath path) {
        String eval = this.delegate.eval(String.format("ls -A %s", path));
        return eval.lines().map(xva$0 -> path.climb((String)xva$0)).collect(Collectors.toList());
    }

    public PosixPath makeDir(PosixPath newDir) {
        this.delegate.eval(String.format("mkdir %s", newDir));
        return newDir.isAbsolute() ? newDir : this.getCurrent().climb(newDir);
    }

    public boolean dirExists(PosixPath newDir) {
        return this.delegate.eval(String.format("if [ -d %s ]; then echo \"YES\"; else echo \"NO\"; fi", newDir)).contains("YES");
    }

    public boolean exists(PosixPath path) {
        return this.fileExists(path) || this.dirExists(path);
    }

    public boolean fileExists(PosixPath newDir) {
        return this.delegate.eval(String.format("if [ -f %s ]; then echo \"YES\"; else echo \"NO\"; fi", newDir)).contains("YES");
    }

    public boolean removeDir(PosixPath newDir) {
        String eval = this.delegate.eval(String.format("rm -vrf %s", newDir));
        return eval.lines().findAny().isPresent();
    }

    public boolean remove(PosixPath path) {
        if (this.dirExists(path)) {
            return this.removeDir(path);
        }
        return this.removeFile(path);
    }

    public boolean removeFile(PosixPath file) {
        StringBuilder err = new StringBuilder();
        StringBuilder std = new StringBuilder();
        int eval = this.delegate.exec(String.format("rm -vf %s", file), std::append, err::append);
        if (eval != 0) {
            throw new RuntimeException(String.format("Could not remove file %s, because %s", file, err));
        }
        return std.toString().lines().findAny().isPresent();
    }
}

