/*
 * Decompiled with CFR 0.152.
 */
package io.github.zebin.javabash.sandbox;

import io.github.zebin.javabash.sandbox.DirectoryTree;
import io.github.zebin.javabash.sandbox.FileManager;
import io.github.zebin.javabash.sandbox.PosixPath;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class WorkingDirectory
implements DirectoryTree {
    private final FileManager delegate;

    public WorkingDirectory(FileManager delegate) {
        this.delegate = delegate;
    }

    @Override
    public Writer put(PosixPath path) {
        this.validate(path);
        if (path.length() > 1) {
            this.delegate.makeDir(path.descend());
        }
        return this.delegate.write(path);
    }

    @Override
    public boolean delete(PosixPath path) {
        this.validate(path);
        return this.delegate.remove(path);
    }

    @Override
    public Writer patch(PosixPath path) {
        this.validate(path);
        if (path.length() > 1) {
            this.delegate.makeDir(path.descend());
        }
        return this.delegate.append(path);
    }

    @Override
    public Reader get(PosixPath path) {
        this.validate(path);
        return new StringReader(this.delegate.read(path));
    }

    @Override
    public boolean exists(PosixPath path) {
        this.validate(path);
        return this.delegate.exists(path);
    }

    @Override
    public boolean isDir(PosixPath path) {
        this.validate(path);
        return this.delegate.dirExists(path);
    }

    @Override
    public int run(String cmd, Consumer<String> stdOut, Consumer<String> stdErr) {
        return this.delegate.run(cmd, stdOut, stdErr);
    }

    @Override
    public Stream<PosixPath> list(PosixPath path) {
        this.validate(path);
        return this.delegate.list(path).stream().filter(p -> !p.equals(PosixPath.CURRENT) && !p.equals(PosixPath.LEVEL_UP));
    }
}

