package io.github.andreyzebin.gitSql;

import io.github.zebin.javabash.sandbox.PosixPath;

import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface FileSystem extends AutoCloseable {

    Writer put(Path path);

    default Writer put(PosixPath path) {
        return put(path.toPath());
    }

    boolean erase(Path path);

    default boolean erase(PosixPath path) {
        return erase(path.toPath());
    }

    Writer patch(Path path);

    default Writer patch(PosixPath path) {
        return patch(path.toPath());
    }

    Reader get(Path path);

    default Reader get(PosixPath path) {
        return get(path.toPath());
    }

    boolean exists(Path path);

    default boolean exists(PosixPath path) {
        return exists(path.toPath());
    }

    boolean isDir(Path path);

    default boolean isDir(PosixPath path) {
        return isDir(path.toPath());
    }

    int run(String cmd, Consumer<String> stdOut, Consumer<String> stdErr);

    default String eval(String comm) {
        StringBuilder stringBuilder = new StringBuilder();
        int exec = run(comm, stringBuilder::append, stringBuilder::append);
        if (exec != 0) {
            throw new RuntimeException(String.format("Could not evaluate '%s', returned non-zero: " + exec, comm));
        }
        return stringBuilder.toString().lines().collect(Collectors.joining(System.lineSeparator()));
    }

    void find(Function<Path, Boolean> needContinue, Consumer<Path> sayBye, Comparator<Path> sorting);

    default void find(Function<Path, Boolean> needContinue) {
        find(needContinue, (p) -> {
        }, FileSystemUtils.filesFirst());
    }

    void flush();

    default FileSystem subTree(Path jump) {
        return new FileSystemSubDirectory(this, jump);
    }

    default FileSystem subTree(PosixPath jump) {
        return subTree(jump.toPath());
    }
}
