package io.github.andreyzebin.gitSql.git;

import io.github.zebin.javabash.process.TextTerminal;

import java.nio.file.Path;
import java.util.Objects;

public class CommitSource extends AbstractVersionControl implements GitSource, GitVersions {

    private final String commit;
    private Path root;
    private final GitSource source;

    public CommitSource(
            TextTerminal bash,
            GitSource source,
            String commit
    ) {
        super(bash);
        this.commit = commit;
        this.source = source;
    }

    @Override
    public Path getRoot() {
        if (root == null) {
            root = source.getRoot();
            seek(commit);
        }

        return root;
    }

    @Override
    public void pull() {
        source.pull();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CommitSource that = (CommitSource) o;
        return Objects.equals(commit, that.commit) && Objects.equals(source, that.source);
    }

    @Override
    public void flush() {
        source.flush();
    }

    @Override
    public void close() throws Exception {
        source.close();
    }
}
