package io.github.andreyzebin.gitSql.git;


import io.github.zebin.javabash.process.TextTerminal;
import io.github.zebin.javabash.sandbox.BashUtils;
import io.github.zebin.javabash.sandbox.DirectoryTree;
import io.github.zebin.javabash.sandbox.FileManager;
import io.github.zebin.javabash.sandbox.WorkingDirectory;
import lombok.extern.slf4j.Slf4j;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;

@Slf4j
public class LocalSource extends AbstractVersionControl implements GitVersions {

    private final Path root;
    private final TextTerminal term;
    private StringBuffer stage = new StringBuffer();

    public LocalSource(Path root, TextTerminal term) {
        super(term);
        this.term = term;
        this.root = root.toAbsolutePath();
    }

    public DirectoryTree getDirectory() {
        return new WorkingDirectory(
                new FileManager(term),
                (f) -> BashUtils.append(stage, f.getPath().toString())
        );
    }

    @Override
    public Path getRoot() {
        return root;
    }

    @Override
    public void flush() {
        if (!stage.toString().isBlank()) {
            BashUtils.lockDir(
                    term,
                    () -> {
                        term.eval("cd " + BashUtils.encode(getRoot()));
                        Arrays.stream(stage.toString().split(System.lineSeparator()))
                                .forEach(cFile -> GitBindings.add(term, Path.of(cFile)));
                        if (GitBindings.hasStatus(term)) {
                            GitBindings.commit(term);
                        } else {
                            log.debug("Status has no changes, skip commit.");
                        }

                        return 0;
                    }
            );
        }

        stage = new StringBuffer();
    }

    @Override
    public void pull() {
        String pwd = term.eval("pwd");
        try {
            term.eval("cd " + BashUtils.encode(getRoot()));
            GitBindings.pull(term);
        } finally {
            term.eval("cd " + pwd);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LocalSource that = (LocalSource) o;
        return Objects.equals(root, that.root);
    }

    @Override
    public int hashCode() {
        return Objects.hash(root);
    }
}
