package io.github.andreyzebin.gitSql.sql;


import io.github.andreyzebin.gitSql.git.GitVersions;
import io.github.andreyzebin.gitSql.sql.SqlUtils.SchemaBuilder;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class CommitsIndexMerger implements TableSource {

    private final GitVersions git;
    private final String alias;

    public CommitsIndexMerger(
            GitVersions git,
            String alias
    ) {
        this.git = git;
        this.alias = alias;
    }

    public static String renderSqlLog(String sql) {
        return System.lineSeparator() +
                "---" +
                System.lineSeparator() +
                sql.lines()
                        .map(SqlBrush::sqlRender)
                        .collect(Collectors.joining(System.lineSeparator())) +
                System.lineSeparator() +
                "---";
    }

    @Override
    public SchemaBuilder createSchema() throws SQLException {
        return new SchemaBuilder(alias)
                .withColumn("hash")
                .withColumn("timestamp", "timestamp timestamp NOT NULL")
                .withColumn("origin")
                .withMerge("origin", "hash");
        //.withIndex("UNIQUE NULLS ALL DISTINCT (hash)");
    }

    @Override
    public Stream<Map<String, String>> rows() {
        return git.commits()
                .map(
                        cF -> Map.of(
                                "hash",
                                cF.getHash(),
                                "timestamp",
                                cF.getTimestamp(),
                                "origin",
                                git.origin()
                                        .orElse(git.getRoot().toString())
                        )
                );
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CommitsIndexMerger that = (CommitsIndexMerger) o;
        return Objects.equals(git, that.git) && Objects.equals(alias, that.alias);
    }

    @Override
    public int hashCode() {
        return Objects.hash(git, alias, this.getClass().getName());
    }
}
