/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql;

import io.github.andreyzebin.gitSql.FileSystemSubDirectory;
import io.github.andreyzebin.gitSql.FileSystemUtils;
import io.github.zebin.javabash.sandbox.PosixPath;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface FileSystem
extends AutoCloseable {
    public Writer put(Path var1);

    default public Writer put(PosixPath path) {
        return this.put(path.toPath());
    }

    public boolean erase(Path var1);

    default public boolean erase(PosixPath path) {
        return this.erase(path.toPath());
    }

    public Writer patch(Path var1);

    default public Writer patch(PosixPath path) {
        return this.patch(path.toPath());
    }

    public Reader get(Path var1);

    default public Reader get(PosixPath path) {
        return this.get(path.toPath());
    }

    public boolean exists(Path var1);

    default public boolean exists(PosixPath path) {
        return this.exists(path.toPath());
    }

    public boolean isDir(Path var1);

    default public boolean isDir(PosixPath path) {
        return this.isDir(path.toPath());
    }

    public int run(String var1, Consumer<String> var2, Consumer<String> var3);

    default public String eval(String comm) {
        StringBuilder stringBuilder = new StringBuilder();
        int exec = this.run(comm, stringBuilder::append, stringBuilder::append);
        if (exec != 0) {
            throw new RuntimeException(String.format("Could not evaluate '%s', returned non-zero: " + exec, comm));
        }
        return stringBuilder.toString().lines().collect(Collectors.joining(System.lineSeparator()));
    }

    public void find(Function<Path, Boolean> var1, Consumer<Path> var2, Comparator<Path> var3);

    default public void find(Function<Path, Boolean> needContinue) {
        this.find(needContinue, p -> {}, FileSystemUtils.filesFirst());
    }

    public void flush();

    default public FileSystem subTree(Path jump) {
        return new FileSystemSubDirectory(this, jump);
    }

    default public FileSystem subTree(PosixPath jump) {
        return this.subTree(jump.toPath());
    }
}

