/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git;

import io.github.andreyzebin.gitSql.git.AbstractVersionControl;
import io.github.andreyzebin.gitSql.git.BranchHead;
import io.github.andreyzebin.gitSql.git.DefaultConfigurations;
import io.github.andreyzebin.gitSql.git.GitAuth;
import io.github.andreyzebin.gitSql.git.GitBindings;
import io.github.andreyzebin.gitSql.git.GitConfigurations;
import io.github.andreyzebin.gitSql.git.GitVersions;
import io.github.andreyzebin.gitSql.git.LocalSource;
import io.github.zebin.javabash.process.TextTerminal;
import io.github.zebin.javabash.sandbox.BashUtils;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteOrigin
extends AbstractVersionControl
implements GitVersions {
    private static final Logger log = LoggerFactory.getLogger(RemoteOrigin.class);
    protected String gitUri;
    private final TextTerminal bash;
    private final GitAuth authStrategy;
    protected Path root;
    private final String branch;
    private String defaultBranch;
    private final Path home;
    private final GitConfigurations configurations;

    public RemoteOrigin(String gitUri, TextTerminal bash, GitAuth authStrategy) {
        this(gitUri, bash, authStrategy, null, new DefaultConfigurations(bash));
    }

    public RemoteOrigin(String gitUri, TextTerminal bash, GitAuth authStrategy, String branch) {
        this(gitUri, bash, authStrategy, branch, new DefaultConfigurations(bash));
    }

    public RemoteOrigin(String gitUri, TextTerminal bash, GitAuth authStrategy, String branch, GitConfigurations configurations) {
        super(bash);
        this.branch = branch;
        this.gitUri = gitUri;
        this.bash = bash;
        this.authStrategy = authStrategy;
        this.home = configurations.getHomeTemporaryDir();
        this.configurations = configurations;
    }

    public LocalSource getLocal() {
        return new LocalSource(this.getRoot(), this.bash);
    }

    @Override
    public Optional<String> branch() {
        if (this.branch == null && this.defaultBranch == null) {
            this.defaultBranch = super.branch().orElse(null);
        }
        return Optional.ofNullable(this.branch).or(() -> Optional.ofNullable(this.defaultBranch));
    }

    @Override
    public Optional<String> origin() {
        return Optional.of(this.gitUri);
    }

    @Override
    public void close() throws Exception {
        if (this.root != null) {
            BashUtils.lockDir((TextTerminal)this.bash, () -> {
                log.debug("Cleaning up temporary git root...");
                this.bash.eval("cd " + BashUtils.encode((Path)this.root.getParent()));
                this.bash.eval("rm -rf " + this.root.getFileName().toString());
                return 0;
            });
        }
    }

    public Stream<BranchHead> listBranches() {
        this.authStrategy.beforeRemote(this.bash);
        Stream<BranchHead> remoteBranches = GitBindings.getRemoteBranches(this.authStrategy.injectAuth(this.gitUri), this.bash, this.authStrategy.useAuthHeader());
        this.authStrategy.afterRemote(this.bash);
        return remoteBranches;
    }

    @Override
    public Path getRoot() {
        if (this.root == null) {
            log.debug("Initializing Git root...");
            return (Path)BashUtils.lockDir((TextTerminal)this.bash, () -> {
                String tempDirName = this.configurations.getTemporaryName(this.gitUri, this.branch);
                try {
                    this.bash.eval("cd " + BashUtils.encode((Path)this.home));
                    this.bash.eval("mkdir -p " + tempDirName);
                    this.bash.eval("cd " + tempDirName);
                    this.authStrategy.beforeRemote(this.bash);
                    GitBindings.clone(".", this.bash, this.authStrategy.injectAuth(this.gitUri), false, this.authStrategy.useAuthHeader(), this.branch);
                    this.authStrategy.afterRemote(this.bash);
                    this.root = this.home.resolve(tempDirName);
                    return this.root;
                }
                catch (Exception e) {
                    log.error("Error while loading from remote: ", (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
        }
        return this.root;
    }

    @Override
    public void flush() {
        if (this.root != null) {
            BashUtils.lockDir((TextTerminal)this.bash, () -> {
                this.bash.eval("cd " + BashUtils.encode((Path)this.getRoot()));
                this.authStrategy.beforeRemote(this.bash);
                GitBindings.push(this.bash);
                this.authStrategy.afterRemote(this.bash);
                return 0;
            });
        }
    }

    @Override
    public void pull() {
        BashUtils.lockDir((TextTerminal)this.bash, () -> {
            this.bash.eval("cd " + BashUtils.encode((Path)this.getRoot()));
            this.authStrategy.beforeRemote(this.bash);
            GitBindings.pull(this.bash);
            this.authStrategy.afterRemote(this.bash);
            return 0;
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteOrigin that = (RemoteOrigin)o;
        return Objects.equals(this.gitUri, that.gitUri) && Objects.equals(this.branch, that.branch);
    }

    public int hashCode() {
        return Objects.hash(this.gitUri, this.branch);
    }
}

