package io.github.andreyzebin.gitSql.git;


import io.github.zebin.javabash.process.TextTerminal;
import io.github.zebin.javabash.sandbox.BashUtils;
import io.github.zebin.javabash.sandbox.DirectoryTree;
import io.github.zebin.javabash.sandbox.FileManager;
import io.github.zebin.javabash.sandbox.WorkingDirectory;

import java.nio.file.Path;
import java.util.Objects;

public class DirOriginSource extends AbstractClient {

    private final Path root;
    private final GitAuth authStrategy;
    private StringBuffer stage = new StringBuffer();

    public DirOriginSource(Path root, GitAuth authStrategy, TextTerminal term) {
        super(term);
        this.root = root.toAbsolutePath();
        this.authStrategy = authStrategy;
    }

    @Override
    public Path getRoot() {
        return root;
    }

    @Override
    public void push() {
        String pwd = term.eval("pwd");
        try {
            term.eval("cd " + BashUtils.encode(getRoot()));
            authStrategy.beforeRemote(term);
            GitBindings.push(term);
            authStrategy.afterRemote(term);
        } finally {
            term.eval("cd " + pwd);
        }
    }

    @Override
    public void pull() {
        String pwd = term.eval("pwd");
        try {
            term.eval("cd " + BashUtils.encode(getRoot()));
            authStrategy.beforeRemote(term);
            GitBindings.pull(term);
            authStrategy.afterRemote(term);
        } finally {
            term.eval("cd " + pwd);
        }
    }

    @Override
    public void close() throws Exception {

    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DirOriginSource that = (DirOriginSource) o;
        return Objects.equals(root, that.root);
    }

    @Override
    public int hashCode() {
        return Objects.hash(root);
    }

}
