/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.config;

import io.github.andreyzebin.gitSql.config.ConfigVersions;
import io.github.andreyzebin.gitSql.git.AbstractClient;
import io.github.andreyzebin.gitSql.git.BranchHead;
import io.github.andreyzebin.gitSql.git.GitAPI;
import io.github.zebin.javabash.sandbox.FileManager;
import io.github.zebin.javabash.sandbox.PosixPath;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestTree {
    private static final Logger log = LoggerFactory.getLogger(RequestTree.class);
    private final Function<String, AbstractClient> originFactory;
    private final Function<AbstractClient, ConfigVersions> versionsFactory;
    private final String trunk;
    private final FileManager tt;

    public RequestTree(Function<String, AbstractClient> originFactory, Function<AbstractClient, ConfigVersions> versionsFactory, String trunk, FileManager tt) {
        this.originFactory = originFactory;
        this.versionsFactory = versionsFactory;
        this.trunk = trunk;
        this.tt = tt;
    }

    public Set<String> listBranches() {
        AbstractClient trunkControl = this.originFactory.apply(this.trunk);
        PosixPath location = trunkControl.getLocation();
        this.tt.go(location);
        return trunkControl.listBranches().map(BranchHead::getName).collect(Collectors.toSet());
    }

    public ConfigVersions getBranch(String branch) {
        return this.versionsFactory.apply(this.originFactory.apply(branch));
    }

    public ConfigVersions getTrunk() {
        return this.getBranch(this.trunk);
    }

    public String getOffset(String branch) {
        return this.getBranch(branch).listVersions().map(v -> v.getVersionHash()).filter(v -> {
            GitAPI trunkControl = this.originFactory.apply(this.trunk);
            return trunkControl.contains((String)v);
        }).findFirst().get();
    }

    public boolean merge(String branch, String hash) {
        AbstractClient trunkControl = this.originFactory.apply(this.trunk);
        PosixPath location = trunkControl.getLocation();
        this.tt.go(location);
        try {
            this.tt.getTerminal().eval(RequestTree.inject("git merge %s", hash));
            trunkControl.push();
        }
        catch (RuntimeException e) {
            log.error("Merge failed: ", (Throwable)e);
        }
        StringBuilder sb = new StringBuilder();
        this.tt.getTerminal().exec(RequestTree.inject("git diff --check", new Object[0]), sb::append, sb::append);
        if (sb.toString().lines().findAny().isPresent()) {
            this.tt.getTerminal().eval("git reset --hard");
            this.tt.getTerminal().eval("git checkout master");
            return false;
        }
        return true;
    }

    public static String inject(String gitMerge, Object ... ff) {
        return String.format(gitMerge, ff);
    }
}

