package io.github.andreyzebin.gitSql.config;

import io.github.zebin.javabash.sandbox.PosixPath;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static org.junit.jupiter.api.Assertions.assertEquals;

public interface ConfigHistory {

    String getEffectiveProperty(String hash, PosixPath leaf, String key);

    Set<Map.Entry<PosixPath, String>> getExplodedPropertyKeys(String hash);

    Set<String> getEffectivePropertyKeys(String hash, PosixPath leaf);

    Stream<ConfigVersions.PropertiesVersion> listVersions();

    default Optional<ConfigVersions.PropertiesVersion> topVersion() {
        return listVersions().findFirst();
    }

    default Optional<ConfigVersions.PropertiesVersion> bottomVersion() {
        return listVersions().reduce((a, b) -> b);
    }

    Map<String, String> getEffectiveState(String hash, PosixPath leaf);

    Map<Map.Entry<PosixPath, String>, String> getExplodedState(String hash);

    default Map<String, Change<String>> getEffectiveChanges(PosixPath leaf, String from, String to) {
        return diffChanged(getEffectiveState(from, leaf), getEffectiveState(to, leaf));
    }

    default Map<Map.Entry<PosixPath, String>, Change<String>> getExplodedChanges(String from, String to) {
        return diffChanged(getExplodedState(from), getExplodedState(to));
    }

    Set<PosixPath> getExplodedLeafChanges(String from, String to);

    static <K, V> Map<K, Change<V>> diffChanged(Map<K, V> left, Map<K, V> right) {
        Map<K, Change<V>> difference = new HashMap<>();


        right.forEach((pp, v) -> {

            Change<V> change = Change.<V>builder()
                    .before(left.get(pp))
                    .after(right.get(pp))
                    .build();
            difference.put(pp, change);

        });

        left.forEach((pp, v) -> difference.computeIfAbsent(pp, (ppp) -> Change.<V>builder()
                .before(left.get(pp))
                .after(null)
                .build()));

        return difference.entrySet()
                .stream()
                .filter((e) -> !Objects.equals(e.getValue().getBefore(), e.getValue().getAfter()))
                .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Data
    @Builder
    public static class Change<T> {
        private final T before;
        private final T after;
    }

    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    @Data
    public static class PropertiesVersion {
        public String versionHash;
        public Long createdEpochSec;
    }
}
