package io.github.andreyzebin.gitSql.config;

import io.github.zebin.javabash.sandbox.PosixPath;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

public interface PathMonitor {
    LeafLock getLock(PosixPath leaf);

    boolean unLock(PosixPath leaf, String lockId);

    LeafLock tryLock(PosixPath leaf);

    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    @Data
    public static class LeafLock {
        public String executorId;
        public String lockId;
        public Long obtainedEpochSec;
    }
}
