package io.github.andreyzebin.gitSql.pretty;

import static io.github.andreyzebin.gitSql.pretty.TablePrinter.combine;

import io.github.andreyzebin.gitSql.pretty.TablePrinter;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class TableStreamRow {

    private Map<String, Optional<String>> row;
    private Map<String, Integer> totals;
    private TablePrinter table;

    public Map<String, Optional<String>> getRowWithTotals() {
        return combine(
                getRow(),
                getTotals()
                        .entrySet()
                        .stream()
                        .collect(
                                Collectors.toMap(
                                        Entry::getKey,
                                        ce -> Optional.ofNullable(ce.getValue()).map(Object::toString)
                                )
                        )
        );
    }
}
