package io.github.andreyzebin.gitSql.sql;

import io.github.zebin.javabash.frontend.TerminalPalette;
import io.github.zebin.javabash.frontend.TextBrush;
import lombok.Builder;
import lombok.Data;
import lombok.With;

@Data
@Builder
@With
public class SqlBrush {

    public static String sqlRender(String cmd) {
        return sqlHighlights(new TextBrush(cmd)).toString();
    }

    public static TextBrush sqlHighlights(TextBrush bashTML) {
        for (String f : new String[]{
                "SELECT",
                "FROM",
                "WHERE",
                "MERGE",
                "USING",
                "ON ",
                "WHEN",
                "INSERT",
                "UPDATE",
                "SET",
                "CREATE",
                "TABLE",
                "then"
        }
        ) {
            bashTML.paint(f, TerminalPalette.YELLOW_BOLD_BRIGHT);
        }

        for (String f : new String[]{
                "NOT",
                "not"
        }
        ) {
            bashTML.paint(f, TerminalPalette.RED);
        }

        for (String f : new String[]{
                "NULL"
        }
        ) {
            bashTML.paint(f, TerminalPalette.GREEN_BOLD_BRIGHT);
        }

        for (String f : new String[]{
                "matched"
        }
        ) {
            bashTML.paint(f, TerminalPalette.WHITE_BOLD_BRIGHT);
        }

        for (String f : new String[]{
                "\""}
        ) {
            bashTML.fillSurrounding(f, TerminalPalette.MAGENTA);
        }

        for (String f : new String[]{
                "\""}
        ) {
            bashTML.paint(f, TerminalPalette.RED);
        }

        for (String f : new String[]{
                "'"}
        ) {
            bashTML.fillSurrounding(f, TerminalPalette.GREEN);
        }

        for (String f : new String[]{
                "'"}
        ) {
            bashTML.paint(f, TerminalPalette.RED);
        }
        return bashTML;
    }
}
