/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.cache;

import io.github.andreyzebin.gitSql.cache.DirectoryTreeCacheProxy;
import io.github.andreyzebin.gitSql.cache.GitEventListener;
import io.github.andreyzebin.gitSql.git.BranchHead;
import io.github.andreyzebin.gitSql.git.Change;
import io.github.andreyzebin.gitSql.git.Commit;
import io.github.andreyzebin.gitSql.git.GitFs;
import io.github.andreyzebin.gitSql.git.Versions;
import io.github.zebin.javabash.sandbox.DirectoryTree;
import java.nio.file.Path;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;

public class GitFsCacheProxy
implements GitFs {
    private final AtomicReference<String> cacheControl;
    private final AtomicReference<String> commitCacheControl;
    private final Map<String, String> branchCache;
    private final Map<String, List<Commit>> commitCache;
    private final List<GitEventListener> listeners = new LinkedList<GitEventListener>();
    private final GitFs gfs;

    public GitFsCacheProxy(GitFs gfs, AtomicReference<String> cacheControl, AtomicReference<String> commitCacheControl, Map<String, String> branchCache, Map<String, List<Commit>> commitCache) {
        this.gfs = gfs;
        this.cacheControl = cacheControl;
        this.commitCacheControl = commitCacheControl;
        this.branchCache = branchCache;
        this.commitCache = commitCache;
    }

    public static GitFsCacheProxy cachedProxy(GitFs gfs, AtomicReference<String> cacheControl) {
        HashMap<String, List<Commit>> commitCache = new HashMap<String, List<Commit>>();
        AtomicReference<Object> commitCacheControl = new AtomicReference<Object>(null);
        HashMap<String, String> branchCache = new HashMap<String, String>();
        return new GitFsCacheProxy(gfs, cacheControl, commitCacheControl, branchCache, commitCache);
    }

    public void addListener(GitEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Versions seek(String commit) {
        Versions seek = this.gfs.seek(commit);
        this.cacheControl.set(commit);
        this.commitCacheControl.set(commit);
        this.branchCache.remove("branch");
        return seek;
    }

    @Override
    public void setBranch(String branchName) {
        this.gfs.setBranch(branchName);
        this.cacheControl.set(branchName);
        this.commitCacheControl.set(null);
        this.branchCache.put("branch", branchName);
    }

    @Override
    public void merge(String hash) {
        this.gfs.merge(hash);
        this.listeners.forEach(cl -> cl.call("clear"));
        this.commitCacheControl.set(null);
    }

    @Override
    public Stream<BranchHead> listBranches() {
        return this.gfs.listBranches();
    }

    @Override
    public Optional<String> getBranch() {
        return Optional.ofNullable(this.branchCache.computeIfAbsent("branch", br -> this.gfs.getBranch().orElse(null)));
    }

    public Stream<Commit> listCommits() {
        AtomicReference<List<? extends Commit>> commits = new AtomicReference<List<? extends Commit>>();
        if (this.commitCacheControl.get() == null) {
            commits.set(this.gfs.listCommits().toList());
            this.commitCacheControl.set(((Commit)((List)commits.get()).get(0)).getHash());
        }
        return this.commitCache.computeIfAbsent(this.commitCacheControl.get(), cc -> {
            if (commits.get() == null) {
                return this.gfs.listCommits().toList();
            }
            return (List)commits.get();
        }).stream();
    }

    @Override
    public boolean contains(String hash) {
        return this.gfs.contains(hash);
    }

    @Override
    public Stream<? extends Change> getChanges(String hashFrom) {
        return this.gfs.getChanges(hashFrom);
    }

    @Override
    public Stream<? extends Change> getChanges(String hashFrom, String hashTo) {
        return this.gfs.getChanges(hashFrom, hashTo);
    }

    @Override
    public Instant getTimestamp() {
        return this.gfs.getTimestamp();
    }

    @Override
    public void pull() {
        this.gfs.pull();
        this.commitCacheControl.set(null);
        this.listeners.forEach(cl -> cl.call("clear"));
    }

    @Override
    public void push() {
        this.gfs.push();
    }

    @Override
    public void setOrigin(String origin) {
        this.gfs.setOrigin(origin);
    }

    @Override
    public Optional<String> getOrigin() {
        return this.gfs.getOrigin();
    }

    @Override
    public void fetch() {
        this.gfs.fetch();
    }

    @Override
    public void setUpstream(String local, String origin) {
        this.gfs.setUpstream(local, origin);
    }

    @Override
    public Optional<String> getUpstream(String local) {
        return this.gfs.getUpstream(local);
    }

    @Override
    public void reset() {
        this.cacheControl.set(null);
        this.commitCacheControl.set(null);
        this.gfs.reset();
    }

    @Override
    public void commit() {
        this.commitCacheControl.set(null);
        this.gfs.commit();
    }

    @Override
    public Path getRoot() {
        return this.gfs.getRoot();
    }

    @Override
    public DirectoryTree getDirectory() {
        DirectoryTreeCacheProxy dt = DirectoryTreeCacheProxy.cachedProxy(this.gfs.getDirectory(), this.cacheControl);
        this.addListener(dt);
        return dt;
    }

    @Override
    public void close() throws Exception {
        this.gfs.close();
    }
}

