/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.config;

import io.github.andreyzebin.gitSql.config.ConfigHistory;
import io.github.andreyzebin.gitSql.config.ConfigTree;
import io.github.andreyzebin.gitSql.git.GitAPI;
import io.github.zebin.javabash.sandbox.PosixPath;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigVersions
implements ConfigHistory,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ConfigVersions.class);
    public static final String IO_GITHUB_VEZUVIO = "io.github.vezuvio";
    public static final long DEFAULT_LOCK_TIMEOUT_SEC = 3600L;
    private final GitAPI vc;
    private final ConfigTree ct;

    public ConfigVersions(GitAPI vc, ConfigTree ct) {
        this.vc = vc;
        this.ct = ct;
    }

    public boolean pull() {
        this.vc.pull();
        return true;
    }

    public void commit() {
        this.vc.commit();
    }

    public void push() {
        this.vc.push();
    }

    public GitAPI getGitAPI() {
        return this.vc;
    }

    @Override
    public String getEffectiveProperty(String hash, PosixPath leaf, String key) {
        return this.getHistorical(hash, () -> this.ct.getEffectiveProperty(leaf, key));
    }

    @Override
    public Set<Map.Entry<PosixPath, String>> getExplodedPropertyKeys(String hash) {
        return this.ct.getLeafs().flatMap(this::flattenEffectiveProperties).collect(Collectors.toSet());
    }

    private Stream<Map.Entry<PosixPath, String>> flattenEffectiveProperties(PosixPath leaf) {
        return this.getEffectivePropertyKeys(leaf).stream().map(k -> new AbstractMap.SimpleEntry<PosixPath, String>(leaf, (String)k));
    }

    public Optional<String> setProperty(PosixPath leaf, String key, String value) {
        return this.ct.setProperty(leaf, key, value);
    }

    public Optional<String> deleteProperty(PosixPath leaf, String key) {
        return this.ct.deleteProperty(leaf, key);
    }

    public String getEffectiveProperty(PosixPath leaf, String key) {
        return this.ct.getEffectiveProperty(leaf, key);
    }

    public Set<String> getEffectivePropertyKeys(PosixPath leaf) {
        return this.ct.getEffectiveProperties(leaf).keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getHistorical(String hash, Supplier<T> exec) {
        String branch = this.vc.getBranch().get();
        if (!hash.equals(this.vc.listCommits().findFirst().get().getHash())) {
            try {
                this.vc.seek(hash);
                T t = exec.get();
                return t;
            }
            finally {
                this.vc.reset();
                this.vc.setBranch(branch);
            }
        }
        return exec.get();
    }

    @Override
    public Map<String, String> getEffectiveState(String hash, PosixPath leaf) {
        return this.getHistorical(hash, () -> (Map)this.ct.getDirectory().setupDir(() -> this.getEffectivePropertyKeys(hash, leaf).stream().collect(Collectors.toMap(k -> k, k -> this.getEffectiveProperty(hash, leaf, (String)k)))));
    }

    public Map<String, String> getProperties(String hash, PosixPath leaf) {
        return this.getHistorical(hash, () -> (Map)this.ct.getDirectory().setupDir(() -> this.ct.getProperties(leaf)));
    }

    @Override
    public Map<Map.Entry<PosixPath, String>, String> getProperties(String hash) {
        return this.getHistorical(hash, () -> (Map)this.ct.getDirectory().setupDir(() -> this.ct.getLeafs().flatMap(lf -> this.ct.getProperties((PosixPath)lf).entrySet().stream().map(pr -> new AbstractMap.SimpleEntry<AbstractMap.SimpleEntry<PosixPath, String>, String>(new AbstractMap.SimpleEntry<PosixPath, String>((PosixPath)lf, (String)pr.getKey()), (String)pr.getValue()))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue))));
    }

    @Override
    public Set<PosixPath> getExplodedLeafChanges(String from, String to) {
        log.debug("Getting exploded leaf changes...");
        Set<PosixPath> changesExploded = this.getExplodedChanges(from, to).keySet().stream().map(Map.Entry::getKey).collect(Collectors.toSet());
        log.debug("Getting exploded leaf changes...Finished!");
        return changesExploded;
    }

    @Override
    public Map<Map.Entry<PosixPath, String>, String> getExplodedState(String hash) {
        return (Map)this.ct.getDirectory().setupDir(() -> {
            log.debug("Getting exploded state...");
            Map historical = this.getHistorical(hash, () -> {
                log.debug("Getting exploded property keys...");
                Set<Map.Entry<PosixPath, String>> propertyKeys = this.getExplodedPropertyKeys(hash);
                log.debug("Getting exploded property keys...Finished!");
                log.debug("Getting effective state...");
                Map<Map.Entry, String> effState = propertyKeys.stream().map(k -> {
                    String s = this.getEffectiveState(hash, (PosixPath)k.getKey()).get(k.getValue());
                    return new AbstractMap.SimpleEntry<Map.Entry, String>((Map.Entry)k, s);
                }).filter(e -> e.getValue() != null).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
                log.debug("Getting effective state...Finished!");
                return effState;
            });
            log.debug("Getting exploded state...Finished!");
            return historical;
        });
    }

    @Override
    public Set<String> getEffectivePropertyKeys(String hash, PosixPath leaf) {
        return this.getHistorical(hash, () -> this.ct.getEffectiveProperties(leaf).keySet());
    }

    @Override
    public Map<String, String> getEffectiveProperties(String hash, PosixPath leaf) {
        return this.getHistorical(hash, () -> this.ct.getEffectiveProperties(leaf));
    }

    public Stream<PosixPath> getLeafs() {
        return this.ct.getLeafs();
    }

    @Override
    public Stream<ConfigHistory.PropertiesVersion> listVersions() {
        return this.vc.listCommits().map(c -> ConfigHistory.PropertiesVersion.builder().versionHash(c.getHash()).createdEpochSec(ConfigVersions.toEpochSeconds(c.getTimestamp())).build());
    }

    public static long toEpochSeconds(String timestamp) {
        return Instant.from(DateTimeFormatter.ISO_DATE_TIME.parse(timestamp)).toEpochMilli() / 1000L;
    }

    public static long getNowEpochSec() {
        return Instant.now().getEpochSecond();
    }

    @Override
    public void close() throws Exception {
    }
}

