/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git;

import io.github.andreyzebin.gitSql.config.DirectoryTreeFactory;
import io.github.andreyzebin.gitSql.git.AbstractClient;
import io.github.andreyzebin.gitSql.git.GitAuth;
import io.github.andreyzebin.gitSql.git.GitBindings;
import io.github.zebin.javabash.process.TextTerminal;
import io.github.zebin.javabash.sandbox.AllFileManager;
import io.github.zebin.javabash.sandbox.BashUtils;
import io.github.zebin.javabash.sandbox.FileManager;
import java.nio.file.Path;
import java.util.Objects;

public class DirOriginSource
extends AbstractClient {
    private final Path root;
    private final GitAuth authStrategy;
    private final TextTerminal term;
    private StringBuffer stage = new StringBuffer();

    public DirOriginSource(Path root, GitAuth authStrategy, FileManager fm, DirectoryTreeFactory dtf) {
        super((AllFileManager)fm, dtf);
        this.term = fm.getTerminal();
        this.root = root.toAbsolutePath();
        this.authStrategy = authStrategy;
    }

    @Override
    public Path getRoot() {
        return this.root;
    }

    @Override
    public void push() {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + BashUtils.encode((Path)this.getRoot()));
            this.authStrategy.beforeRemote(this.term);
            GitBindings.push(this.term);
            this.authStrategy.afterRemote(this.term);
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    @Override
    public void pull() {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + BashUtils.encode((Path)this.getRoot()));
            this.authStrategy.beforeRemote(this.term);
            GitBindings.pull(this.term);
            this.authStrategy.afterRemote(this.term);
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    @Override
    public void close() throws Exception {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirOriginSource that = (DirOriginSource)o;
        return Objects.equals(this.root, that.root);
    }

    public int hashCode() {
        return Objects.hash(this.root);
    }
}

