package io.github.andreyzebin.gitSql.git;


import io.github.andreyzebin.gitSql.config.DirectoryTreeFactory;
import io.github.zebin.javabash.process.TextTerminal;
import io.github.zebin.javabash.sandbox.*;
import lombok.extern.slf4j.Slf4j;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;

@Slf4j
public class LocalSource extends AbstractClient {

    private final Path root;
    private final TextTerminal term;
    private final AllFileManager fm;

    public LocalSource(Path root, AllFileManager term) {
        super(term, WorkingDirectory::new);
        this.term = term.getTerminal();
        this.fm = term;
        this.root = root.toAbsolutePath();
    }

    @Override
    public Path getRoot() {
        return root;
    }

    @Override
    public void pull() {
        String pwd = term.eval("pwd");
        try {
            term.eval("cd " + BashUtils.encode(getRoot()));
            GitBindings.pull(term);
        } finally {
            term.eval("cd " + pwd);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LocalSource that = (LocalSource) o;
        return Objects.equals(root, that.root);
    }

    @Override
    public int hashCode() {
        return Objects.hash(root);
    }
}
