package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.sql.SqlUtils.SchemaBuilder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.stream.Stream;

public interface TableSource {

    SchemaBuilder createSchema() throws SQLException;

    Stream<Map<String, String>> rows();

    default TableSource updates(String fromVersion) {
        return this;
    }

    default String version() {
        return "1.0.0";
    }
}
