package io.github.andreyzebin.gitSql.git;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.List;

@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public
class Commit {

    private List<String> parents;
    private String hash;
    // ISO DATE_TIME
    private String timestamp;
    private String unixTimestamp;
    private String committerEmail;
    private String committerName;
    private String authorEmail;
    private String authorName;


    @JsonIgnore
    public Instant getTimestampInstant() {
        return Instant.from(DateTimeFormatter.ISO_INSTANT.parse(timestamp));
    }
}
