package io.github.andreyzebin.gitSql.git;

import io.github.andreyzebin.gitSql.config.DirectoryTreeFactory;
import io.github.zebin.javabash.sandbox.AllFileManager;
import io.github.zebin.javabash.sandbox.FileManager;

import java.nio.file.Path;
import java.util.Objects;

public class CommitSource extends AbstractClient {

    private final String commit;
    private Path root;
    private final GitDirectory source;

    public CommitSource(
            AllFileManager bash,
            GitDirectory source,
            String commit,
            DirectoryTreeFactory dtf
    ) {
        super(bash, dtf);
        this.commit = commit;
        this.source = source;
    }

    @Override
    public Path getRoot() {
        if (root == null) {
            root = source.getRoot();
            seek(commit);
        }

        return root;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CommitSource that = (CommitSource) o;
        return Objects.equals(commit, that.commit) && Objects.equals(source, that.source);
    }

    @Override
    public void close() throws Exception {
        source.close();
    }

}
