/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.config;

import io.github.zebin.javabash.sandbox.PosixPath;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface ConfigHistory {
    public String getEffectiveProperty(String var1, PosixPath var2, String var3);

    public Set<Map.Entry<PosixPath, String>> getExplodedPropertyKeys(String var1);

    public Set<String> getEffectivePropertyKeys(String var1, PosixPath var2);

    public Map<String, String> getEffectiveProperties(String var1, PosixPath var2);

    public Stream<PropertiesVersion> listVersions();

    default public Optional<PropertiesVersion> topVersion() {
        return this.listVersions().findFirst();
    }

    default public Optional<PropertiesVersion> bottomVersion() {
        return this.listVersions().reduce((a, b) -> b);
    }

    public Map<String, String> getEffectiveState(String var1, PosixPath var2);

    public Map<Map.Entry<PosixPath, String>, String> getExplodedState(String var1);

    default public Map<String, Change<String>> getEffectiveChanges(PosixPath leaf, String from, String to) {
        return ConfigHistory.diffChanged(this.getEffectiveState(from, leaf), this.getEffectiveState(to, leaf));
    }

    default public Map<Map.Entry<PosixPath, String>, Change<String>> getExplodedChanges(String from, String to) {
        return ConfigHistory.diffChanged(this.getExplodedState(from), this.getExplodedState(to));
    }

    default public Map<Map.Entry<PosixPath, String>, Change<String>> getChanges(String from, String to) {
        return ConfigHistory.diffChanged(this.getProperties(from), this.getProperties(to));
    }

    public Map<Map.Entry<PosixPath, String>, String> getProperties(String var1);

    public Set<PosixPath> getExplodedLeafChanges(String var1, String var2);

    public static <K, V> Map<K, Change<V>> diffChanged(Map<K, V> left, Map<K, V> right) {
        HashMap difference = new HashMap();
        right.forEach((pp, v) -> {
            Change change = Change.builder().before(left.get(pp)).after(right.get(pp)).build();
            difference.put(pp, change);
        });
        left.forEach((pp, v) -> difference.computeIfAbsent(pp, ppp -> Change.builder().before(left.get(pp)).after(null).build()));
        return difference.entrySet().stream().filter(e -> !Objects.equals(((Change)e.getValue()).getBefore(), ((Change)e.getValue()).getAfter())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static class Change<T> {
        private final T before;
        private final T after;

        Change(T before, T after) {
            this.before = before;
            this.after = after;
        }

        public static <T> ChangeBuilder<T> builder() {
            return new ChangeBuilder();
        }

        public T getBefore() {
            return this.before;
        }

        public T getAfter() {
            return this.after;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Change)) {
                return false;
            }
            Change other = (Change)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$before = this.getBefore();
            T other$before = other.getBefore();
            if (this$before == null ? other$before != null : !this$before.equals(other$before)) {
                return false;
            }
            T this$after = this.getAfter();
            T other$after = other.getAfter();
            return !(this$after == null ? other$after != null : !this$after.equals(other$after));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Change;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $before = this.getBefore();
            result = result * 59 + ($before == null ? 43 : $before.hashCode());
            T $after = this.getAfter();
            result = result * 59 + ($after == null ? 43 : $after.hashCode());
            return result;
        }

        public String toString() {
            return "ConfigHistory.Change(before=" + String.valueOf(this.getBefore()) + ", after=" + String.valueOf(this.getAfter()) + ")";
        }

        public static class ChangeBuilder<T> {
            private T before;
            private T after;

            ChangeBuilder() {
            }

            public ChangeBuilder<T> before(T before) {
                this.before = before;
                return this;
            }

            public ChangeBuilder<T> after(T after) {
                this.after = after;
                return this;
            }

            public Change<T> build() {
                return new Change<T>(this.before, this.after);
            }

            public String toString() {
                return "ConfigHistory.Change.ChangeBuilder(before=" + String.valueOf(this.before) + ", after=" + String.valueOf(this.after) + ")";
            }
        }
    }

    public static class PropertiesVersion {
        public String versionHash;
        public Long createdEpochSec;

        public static PropertiesVersionBuilder builder() {
            return new PropertiesVersionBuilder();
        }

        public PropertiesVersion(String versionHash, Long createdEpochSec) {
            this.versionHash = versionHash;
            this.createdEpochSec = createdEpochSec;
        }

        public PropertiesVersion() {
        }

        public String getVersionHash() {
            return this.versionHash;
        }

        public Long getCreatedEpochSec() {
            return this.createdEpochSec;
        }

        public void setVersionHash(String versionHash) {
            this.versionHash = versionHash;
        }

        public void setCreatedEpochSec(Long createdEpochSec) {
            this.createdEpochSec = createdEpochSec;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertiesVersion)) {
                return false;
            }
            PropertiesVersion other = (PropertiesVersion)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$createdEpochSec = this.getCreatedEpochSec();
            Long other$createdEpochSec = other.getCreatedEpochSec();
            if (this$createdEpochSec == null ? other$createdEpochSec != null : !((Object)this$createdEpochSec).equals(other$createdEpochSec)) {
                return false;
            }
            String this$versionHash = this.getVersionHash();
            String other$versionHash = other.getVersionHash();
            return !(this$versionHash == null ? other$versionHash != null : !this$versionHash.equals(other$versionHash));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PropertiesVersion;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $createdEpochSec = this.getCreatedEpochSec();
            result = result * 59 + ($createdEpochSec == null ? 43 : ((Object)$createdEpochSec).hashCode());
            String $versionHash = this.getVersionHash();
            result = result * 59 + ($versionHash == null ? 43 : $versionHash.hashCode());
            return result;
        }

        public String toString() {
            return "ConfigHistory.PropertiesVersion(versionHash=" + this.getVersionHash() + ", createdEpochSec=" + this.getCreatedEpochSec() + ")";
        }

        public static class PropertiesVersionBuilder {
            private String versionHash;
            private Long createdEpochSec;

            PropertiesVersionBuilder() {
            }

            public PropertiesVersionBuilder versionHash(String versionHash) {
                this.versionHash = versionHash;
                return this;
            }

            public PropertiesVersionBuilder createdEpochSec(Long createdEpochSec) {
                this.createdEpochSec = createdEpochSec;
                return this;
            }

            public PropertiesVersion build() {
                return new PropertiesVersion(this.versionHash, this.createdEpochSec);
            }

            public String toString() {
                return "ConfigHistory.PropertiesVersion.PropertiesVersionBuilder(versionHash=" + this.versionHash + ", createdEpochSec=" + this.createdEpochSec + ")";
            }
        }
    }
}

