/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jdbc.log.invocation;

import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sk.antons.jdbc.log.JdbcWrapper;
import sk.antons.jdbc.log.LogConfig;
import sk.antons.jdbc.log.invocation.CommonHandler;
import sk.antons.jdbc.log.invocation.Identities;

public class PreparedStatementHandler
extends CommonHandler {
    PreparedStatement stm = null;
    String statement = null;
    Map<Integer, String> params = new HashMap<Integer, String>();

    public PreparedStatementHandler(PreparedStatement stm, String statement, LogConfig config, int connidentity) {
        super(stm, config, connidentity, Identities.nextStatement());
        this.stm = stm;
        this.statement = statement;
    }

    public static PreparedStatementHandler instance(PreparedStatement stm, String statement, LogConfig config, int connidentity) {
        return new PreparedStatementHandler(stm, statement, config, connidentity);
    }

    @Override
    protected void preInvoke(Method method, Object[] args) {
    }

    @Override
    protected Object postInvoke(Method method, Object[] args, Object o) {
        if (this.config.consumerStatus().isConsumerOn()) {
            String name = method.getName();
            if ("executeQuery".equals(name)) {
                StringBuilder sb = new StringBuilder();
                this.consumerPrefix(sb);
                sb.append(" statement: ").append(this.statement);
                sb.append(" params: ").append(this.params());
                this.consumerPostfix(sb);
                this.config.consumer().consume(sb.toString());
                if (this.config.logResult() && o != null) {
                    o = JdbcWrapper.wrap((ResultSet)o, this.config, this.connidentity, this.stmidentity);
                }
                this.params.clear();
            } else if ("executeUpdate".equals(name)) {
                StringBuilder sb = new StringBuilder();
                this.consumerPrefix(sb);
                sb.append(" statement: ").append(this.statement);
                sb.append(" params: ").append(this.params());
                sb.append(" result: ").append(o);
                this.consumerPostfix(sb);
                this.config.consumer().consume(sb.toString());
                this.params.clear();
            } else if (name.startsWith("set")) {
                this.addParam(method, args);
            }
        }
        return o;
    }

    private void addParam(Method method, Object[] args) {
        if (method.getParameterTypes().length < 2) {
            return;
        }
        if (method.getParameterTypes().length > 3) {
            return;
        }
        Class<?> c = method.getParameterTypes()[0];
        if (!Integer.TYPE.isAssignableFrom(c)) {
            return;
        }
        Object value = args[1];
        String svalue = "" + value;
        int key = (Integer)args[0];
        this.params.put(key, svalue);
    }

    private String params() {
        ArrayList<Integer> keys = new ArrayList<Integer>();
        keys.addAll(this.params.keySet());
        Collections.sort(keys);
        StringBuilder sb = new StringBuilder();
        for (Integer key : keys) {
            String value = this.params.get(key);
            sb.append(" ?").append(key).append(':').append(value);
        }
        return sb.toString();
    }
}

