/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jdbc.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

public class Db
implements AutoCloseable {
    private DataSource ds = null;
    private Connection conn = null;
    private Statement st = null;
    private PreparedStatement ps = null;
    private ResultSet rs = null;
    private String laststm = null;

    public Db(DataSource ds) {
        this.ds = ds;
    }

    public static Db instance(DataSource ds) {
        return new Db(ds);
    }

    @Override
    public void close() throws Exception {
        this.closeResultSet();
        this.closePreparedStatement();
        this.closeStatement();
        this.closeConnection();
    }

    public DataSource ds() {
        return this.ds;
    }

    public PreparedStatement ps() {
        return this.ps;
    }

    public Statement st() {
        return this.st;
    }

    public ResultSet rs() {
        return this.rs;
    }

    public Connection conn() throws SQLException {
        if (this.conn == null) {
            this.conn = this.ds.getConnection();
            this.conn.setAutoCommit(false);
            this.conn.setTransactionIsolation(2);
        }
        return this.conn;
    }

    private Statement st_() throws SQLException {
        if (this.st == null) {
            this.st = this.conn().createStatement();
        }
        return this.st;
    }

    public int executeUpdate(String statement) throws SQLException {
        this.laststm = statement;
        try {
            return this.st_().executeUpdate(statement);
        }
        catch (SQLException e) {
            if (this.laststm != null) {
                throw new SQLException("last statement: " + this.laststm, e);
            }
            throw e;
        }
    }

    public ResultSet executeQuery(String statement) throws SQLException {
        this.laststm = statement;
        try {
            this.closeResultSet();
            this.rs = this.st_().executeQuery(statement);
            return this.rs;
        }
        catch (SQLException e) {
            if (this.laststm != null) {
                throw new SQLException("last statement: " + this.laststm, e);
            }
            throw e;
        }
    }

    public void prepareStatement(String statement) throws SQLException {
        this.laststm = statement;
        try {
            this.closePreparedStatement();
            this.ps = this.conn().prepareStatement(statement);
        }
        catch (SQLException e) {
            if (this.laststm != null) {
                throw new SQLException("last statement: " + this.laststm, e);
            }
            throw e;
        }
    }

    public int executeUpdate() throws SQLException {
        try {
            return this.ps.executeUpdate();
        }
        catch (SQLException e) {
            if (this.laststm != null) {
                throw new SQLException("last statement: " + this.laststm, e);
            }
            throw e;
        }
    }

    public ResultSet executeQuery() throws SQLException {
        try {
            this.closeResultSet();
            this.rs = this.ps.executeQuery();
            return this.rs;
        }
        catch (SQLException e) {
            if (this.laststm != null) {
                throw new SQLException("last statement: " + this.laststm, e);
            }
            throw e;
        }
    }

    public void closeResultSet() {
        try {
            if (this.rs != null && !this.rs.isClosed()) {
                this.rs.close();
            }
            this.rs = null;
            this.laststm = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeStatement() {
        try {
            if (this.st != null && !this.st.isClosed()) {
                this.st.close();
            }
            this.st = null;
            this.laststm = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closePreparedStatement() {
        try {
            if (this.ps != null && !this.ps.isClosed()) {
                this.ps.close();
            }
            this.ps = null;
            this.laststm = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeConnection() {
        try {
            if (this.conn != null) {
                this.conn.rollback();
            }
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
            }
            this.conn = null;
            this.laststm = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

