/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jdbc.util;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class SqlToHtml {
    private Connection conn;
    private String sql;
    private List<String> header;
    private List<String> fieldsHeader;
    private List<String> fields;
    private int page = 0;
    private int pagelen = 0;
    private StringBuilder sb = new StringBuilder();

    public SqlToHtml(Connection conn) {
        this.conn = conn;
    }

    public static SqlToHtml instance(Connection conn) {
        return new SqlToHtml(conn);
    }

    public SqlToHtml sql(String value) {
        this.sql = value;
        return this;
    }

    public SqlToHtml sqlHeader(List<String> value) {
        this.header = value;
        return this;
    }

    public SqlToHtml fieldsHeader(List<String> value) {
        this.fieldsHeader = value;
        return this;
    }

    public SqlToHtml fields(List<String> value) {
        this.fields = value;
        return this;
    }

    public SqlToHtml page(int value) {
        this.page = value;
        return this;
    }

    public SqlToHtml pagelen(int value) {
        this.pagelen = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table build() {
        Table table = new Table();
        if (this.sql == null) {
            table.error = "no sql";
            return table;
        }
        this.sql = this.clearSql(this.sql);
        if (this.pagelen < 1) {
            this.page = 0;
        }
        if (this.sql.toLowerCase().trim().startsWith("select")) {
            this.sb.append("<table class=\"report\">\n");
            ResultSet rs = null;
            Statement stmt = null;
            try {
                stmt = this.conn.createStatement();
                rs = stmt.executeQuery(this.sql);
                ResultSetMetaData md = rs.getMetaData();
                int columnCount = md.getColumnCount();
                ArrayList<String> labels = new ArrayList<String>();
                for (int i = 0; i < columnCount; ++i) {
                    String label = md.getColumnLabel(i + 1);
                    if (label == null) {
                        label = "";
                    }
                    labels.add(label.toLowerCase());
                }
                if (this.header == null || this.header.isEmpty()) {
                    this.header = labels;
                }
                this.rowStart("header");
                if (this.header != null && !this.header.isEmpty()) {
                    for (String string : this.header) {
                        this.coll(string);
                    }
                }
                if (this.fieldsHeader != null && !this.fieldsHeader.isEmpty()) {
                    for (String string : this.fieldsHeader) {
                        this.coll(string);
                    }
                }
                this.rowEnd();
                SimpleDateFormat dFromat = new SimpleDateFormat("yyyy.MM.dd");
                SimpleDateFormat tsFromat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
                boolean paggig = this.page > -1 && this.pagelen > 0;
                int startindex = this.page * this.pagelen;
                int endindex = startindex + this.pagelen;
                int index = -1;
                int size = 0;
                while (rs.next()) {
                    ++index;
                    if (paggig) {
                        if (index < startindex) continue;
                        if (index >= endindex) break;
                    }
                    ++size;
                    HashMap<String, String> row = new HashMap<String, String>();
                    this.rowStart();
                    for (int i = 0; i < columnCount; ++i) {
                        String value = null;
                        String name = labels.size() <= i ? null : (String)labels.get(i);
                        int type = md.getColumnType(i + 1);
                        value = type == 93 ? SqlToHtml.formatDate(tsFromat, rs.getTimestamp(i + 1)) : (type == 91 ? SqlToHtml.formatDate(dFromat, rs.getDate(i + 1)) : rs.getString(i + 1));
                        String style = null;
                        if (type == 93) {
                            style = "time";
                        } else if (type == 91) {
                            style = "date";
                        } else if (SqlToHtml.isNumberType(type)) {
                            style = "number";
                        }
                        this.coll(value, style);
                        row.put(name, value);
                    }
                    if (this.fields != null && !this.fields.isEmpty()) {
                        Iterator<String> iterator = this.fields.iterator();
                        while (iterator.hasNext()) {
                            String field;
                            String value = field = iterator.next();
                            if (field != null) {
                                for (Map.Entry entry : row.entrySet()) {
                                    String key = (String)entry.getKey();
                                    String va = (String)entry.getValue();
                                    if (va == null) {
                                        va = "";
                                    }
                                    value = value.replace("${" + key + "}", va);
                                }
                            }
                            this.coll(value);
                        }
                    }
                    this.rowEnd();
                }
                this.sb.append("</table>\n");
                table.size = size;
                table.html = this.sb.toString();
                Table table2 = table;
                return table2;
            }
            catch (Exception e) {
                table.error = e.toString();
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        table.error = "no selext present";
        return table;
    }

    private String clearSql(String sql) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(sql, "\n\r");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line == null || (line = line.trim()).startsWith("--")) continue;
            sb.append(' ').append(line).append(' ');
        }
        return sb.toString().trim();
    }

    private static boolean isNumberType(int type) {
        if (type == -5) {
            return true;
        }
        if (type == 8) {
            return true;
        }
        if (type == 6) {
            return true;
        }
        if (type == 4) {
            return true;
        }
        if (type == 2) {
            return true;
        }
        if (type == 7) {
            return true;
        }
        if (type == 5) {
            return true;
        }
        return type == -6;
    }

    private static String formatDate(SimpleDateFormat df, Date value) {
        if (value == null) {
            return null;
        }
        if (df == null) {
            return value.toString();
        }
        return df.format(value);
    }

    private static String formatDate(SimpleDateFormat df, Timestamp value) {
        if (value == null) {
            return null;
        }
        if (df == null) {
            return value.toString();
        }
        return df.format(value);
    }

    private void rowEnd() {
        this.sb.append("</tr>\n");
    }

    private void rowStart() {
        this.rowStart(null);
    }

    private void rowStart(String classes) {
        if (classes == null) {
            this.sb.append(" <tr>\n");
        } else {
            this.sb.append(" <tr class=\"").append(classes).append("\">\n");
        }
    }

    private void coll(String value) {
        this.coll(value, null);
    }

    private void coll(String value, String classes) {
        if (classes == null) {
            this.sb.append("  <td>");
        } else {
            this.sb.append("  <td class=\"").append(classes).append("\">");
        }
        if (value != null) {
            this.sb.append(value);
        }
        this.sb.append("</td>\n");
    }

    public static class Table {
        String html;
        String error;
        int size;

        public String getError() {
            return this.error;
        }

        public String getHtml() {
            return this.html;
        }

        public int getSize() {
            return this.size;
        }
    }
}

