/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.sbsplitter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.plugin.logging.Log;
import sk.antons.sbsplitter.WildMatcher;

public class SBSplitter {
    private String filename;
    private String destDir;
    private String sourceLibFolder;
    private String destLibFolder;
    private String destAppFolder;
    private String cpFile;
    private String cpScript;
    private String cpClassesPrefix;
    private String cpAppPrefix;
    private String cpLibPrefix;
    private String[] appModuleNames;
    private String[] appModulePackages;
    private List<WildMatcher> wildMathers = null;

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
    }

    public String getSourceLibFolder() {
        return this.sourceLibFolder;
    }

    public void setSourceLibFolder(String sourceLibFolder) {
        this.sourceLibFolder = sourceLibFolder;
    }

    public String getDestLibFolder() {
        return this.destLibFolder;
    }

    public void setDestLibFolder(String destLibFolder) {
        this.destLibFolder = destLibFolder;
    }

    public String getDestAppFolder() {
        return this.destAppFolder;
    }

    public void setDestAppFolder(String destAppFolder) {
        this.destAppFolder = destAppFolder;
    }

    public String getCpFile() {
        return this.cpFile;
    }

    public void setCpFile(String cpFile) {
        this.cpFile = cpFile;
    }

    public String getCpScript() {
        return this.cpScript;
    }

    public void setCpScript(String cpScript) {
        this.cpScript = cpScript;
    }

    public String getCpClassesPrefix() {
        return this.cpClassesPrefix;
    }

    public void setCpClassesPrefix(String cpClassesPrefix) {
        this.cpClassesPrefix = cpClassesPrefix;
    }

    public String getCpAppPrefix() {
        return this.cpAppPrefix;
    }

    public void setCpAppPrefix(String cpAppPrefix) {
        this.cpAppPrefix = cpAppPrefix;
    }

    public String getCpLibPrefix() {
        return this.cpLibPrefix;
    }

    public void setCpLibPrefix(String cpLibPrefix) {
        this.cpLibPrefix = cpLibPrefix;
    }

    public String[] getAppModuleNames() {
        return this.appModuleNames;
    }

    public void setAppModuleNames(String[] appModuleNames) {
        this.appModuleNames = appModuleNames;
    }

    public String[] getAppModulePackages() {
        return this.appModulePackages;
    }

    public void setAppModulePackages(String[] appModulePackages) {
        this.appModulePackages = appModulePackages;
    }

    private void unzip() {
        try {
            File dest = new File(this.destDir);
            if (!dest.exists()) {
                dest.mkdirs();
            }
            byte[] buffer = new byte[1024];
            ZipInputStream zis = new ZipInputStream(new FileInputStream(this.filename));
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                if (!zipEntry.isDirectory()) {
                    int len;
                    File newFile = this.newFile(dest, zipEntry);
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        String fullname = zipEntry.getName();
        File destFile = new File(destinationDir, fullname);
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IllegalArgumentException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        File p = destFile.getParentFile();
        if (!p.exists()) {
            p.mkdirs();
        }
        return destFile;
    }

    private void listFiles(File folder, String prefix, List<String> list) {
        File[] children = folder.listFiles();
        if (children == null) {
            return;
        }
        for (File file : children) {
            String neprefix = file.getName();
            if (prefix != null) {
                neprefix = prefix + "/" + neprefix;
            }
            if (file.isDirectory()) {
                this.listFiles(file, neprefix, list);
                continue;
            }
            list.add(neprefix);
        }
    }

    private boolean isApplicationModule(String filename) {
        boolean rv = this.isApplicationModuleByName(filename);
        if (rv) {
            return true;
        }
        return this.isApplicationModuleByPackage(filename);
    }

    private List<WildMatcher> wildMathers() {
        if (this.wildMathers == null) {
            this.wildMathers = new ArrayList<WildMatcher>();
            for (String appModuleName : this.appModuleNames) {
                this.wildMathers.add(WildMatcher.instance(appModuleName));
            }
        }
        return this.wildMathers;
    }

    private boolean isApplicationModuleByName(String filename) {
        if (this.appModuleNames == null) {
            return false;
        }
        for (String appName : this.appModuleNames) {
            if (!appName.equals(filename)) continue;
            return true;
        }
        for (WildMatcher wm : this.wildMathers()) {
            if (!wm.match(filename)) continue;
            return true;
        }
        return false;
    }

    private boolean isApplicationModuleByPackage(String filename) {
        if (this.appModulePackages == null) {
            return false;
        }
        Set<String> packages = this.listPackages(filename);
        for (String appName : this.appModulePackages) {
            if (!packages.contains(appName)) continue;
            return true;
        }
        return false;
    }

    private Set<String> listPackages(String filename) {
        TreeSet<String> set = new TreeSet<String>();
        try {
            filename = this.destDir + this.sourceLibFolder + filename;
            byte[] buffer = new byte[1024];
            ZipInputStream zis = new ZipInputStream(new FileInputStream(filename));
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                if (zipEntry.isDirectory()) {
                    String name = zipEntry.getName();
                    if ((name = name.replace('/', '.')).startsWith(".")) {
                        name = name.substring(1);
                    }
                    if (name.endsWith(".")) {
                        name = name.substring(0, name.length() - 1);
                    }
                    set.add(name);
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return set;
    }

    public void moveFile(String oldname, String newname) {
        if (oldname.equals(newname)) {
            return;
        }
        try {
            int length;
            File f = new File(oldname);
            File f2 = new File(newname);
            File p = f2.getParentFile();
            if (!p.exists()) {
                p.mkdir();
            }
            FileInputStream is = new FileInputStream(f);
            FileOutputStream os = new FileOutputStream(f2);
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
            os.flush();
            os.close();
            is.close();
            f.delete();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public List<String> loadCP() {
        ArrayList<String> rv = new ArrayList<String>();
        File f = new File(this.destDir + this.cpFile);
        if (!f.exists()) {
            return rv;
        }
        try {
            FileInputStream fis = new FileInputStream(f);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fis, "utf-8"));
            String line = reader.readLine();
            if (line != null) {
                String[] data;
                for (String string : data = line.split(":")) {
                    if (string == null || "".equals(string = string.trim())) continue;
                    File ff = new File(string);
                    rv.add(ff.getName());
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return rv;
    }

    public void generateCPScript(List<String> cp, List<String> appFiles, List<String> libFiles) {
        StringBuilder sb = new StringBuilder();
        sb.append("#!/bin/bash\n\n");
        sb.append("SBCP=").append(this.cpClassesPrefix).append("classes");
        for (String string : cp) {
            if (!appFiles.contains(string)) continue;
            sb.append(":").append(this.cpAppPrefix).append(string);
            appFiles.remove(string);
        }
        for (String string : appFiles) {
            sb.append(":XX").append(this.cpAppPrefix).append(string);
        }
        for (String string : cp) {
            if (!libFiles.contains(string)) continue;
            sb.append(":").append(this.cpLibPrefix).append(string);
            libFiles.remove(string);
        }
        for (String string : libFiles) {
            sb.append(":XX").append(this.cpLibPrefix).append(string);
        }
        sb.append("\n\nexport SBCP\n");
        try {
            File f = new File(this.destDir + this.cpScript);
            File p = f.getParentFile();
            if (!p.exists()) {
                p.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(sb.toString().getBytes("utf-8"));
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void split(Log log) {
        this.unzip();
        log.info((CharSequence)"[SB split] unzipped");
        ArrayList<String> appFiles = new ArrayList<String>();
        ArrayList<String> libFiles = new ArrayList<String>();
        ArrayList<String> files = new ArrayList<String>();
        this.listFiles(new File(this.destDir + this.sourceLibFolder), null, files);
        for (String name : files) {
            String oldname = this.destDir + this.sourceLibFolder + name;
            String newname = null;
            if (this.isApplicationModule(name)) {
                newname = this.destDir + this.destAppFolder + name;
                appFiles.add(name);
            } else {
                newname = this.destDir + this.destLibFolder + name;
                libFiles.add(name);
            }
            this.moveFile(oldname, newname);
        }
        log.info((CharSequence)("[SB split] lib modules splitted. lib count: " + libFiles.size() + " app count: " + appFiles.size()));
        List<String> cp = this.loadCP();
        this.generateCPScript(cp, appFiles, libFiles);
        log.info((CharSequence)"[SB split] classpath script generated");
        this.updateModificationDate(new File(this.destDir + this.destLibFolder), 0L);
        log.info((CharSequence)"[SB split] lib modules freeze modification time");
    }

    public String config() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nsbFile: ").append(this.filename);
        sb.append("\ndestDir: ").append(this.destDir);
        sb.append("\nsourceLibFolder: ").append(this.sourceLibFolder);
        sb.append("\ndestLibFolder: ").append(this.destLibFolder);
        sb.append("\ndestAppFolder: ").append(this.destAppFolder);
        sb.append("\n");
        sb.append("\ncpFile: ").append(this.cpFile);
        sb.append("\ncpScript: ").append(this.cpScript);
        sb.append("\ncpClassesPrefix: ").append(this.cpClassesPrefix);
        sb.append("\ncpAppPrefix: ").append(this.cpAppPrefix);
        sb.append("\ncpLibPrefix: ").append(this.cpLibPrefix);
        if (this.appModuleNames != null && this.appModuleNames.length > 0) {
            sb.append("\n");
            for (String appModuleName : this.appModuleNames) {
                sb.append("\nappModuleName: ").append(appModuleName);
            }
        }
        if (this.appModulePackages != null && this.appModulePackages.length > 0) {
            sb.append("\n");
            for (String appModuleName : this.appModulePackages) {
                sb.append("\nappModulePackage: ").append(appModuleName);
            }
        }
        return sb.toString();
    }

    private void updateModificationDate(File folder, long time) {
        folder.setLastModified(time);
        File[] children = folder.listFiles();
        if (children == null) {
            return;
        }
        for (File file : children) {
            file.setLastModified(time);
            if (!file.isDirectory()) continue;
            this.updateModificationDate(file, time);
        }
    }
}

