/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.sbsplitter;

import java.util.ArrayList;
import java.util.List;

public class WildMatcher {
    private String pattern;
    private List<Element> elements = new ArrayList<Element>();

    public WildMatcher(String pattern) {
        this.pattern = pattern;
        this.preprocessPattern();
    }

    public static WildMatcher instance(String pattern) {
        return new WildMatcher(pattern);
    }

    private void preprocessPattern() {
        int lastindex = 0;
        boolean asterixBefore = false;
        for (int i = 0; i < this.pattern.length(); ++i) {
            char c = this.pattern.charAt(i);
            if (c == '*') {
                if (!asterixBefore) {
                    asterixBefore = true;
                    if (i - lastindex > 0) {
                        this.elements.add(TextElement.instance(this.pattern, lastindex, i - lastindex));
                    }
                    this.elements.add(AsterixElement.instance());
                }
                lastindex = i + 1;
                continue;
            }
            if (c == '?') {
                asterixBefore = false;
                if (i - lastindex > 0) {
                    this.elements.add(TextElement.instance(this.pattern, lastindex, i - lastindex));
                }
                this.elements.add(QuestionmarkElement.instance());
                lastindex = i + 1;
                continue;
            }
            asterixBefore = false;
        }
        if (this.pattern.length() - lastindex > 0) {
            this.elements.add(TextElement.instance(this.pattern, lastindex, this.pattern.length() - lastindex));
        }
    }

    public boolean match(String text) {
        if (text == null) {
            return false;
        }
        if (text.length() == 0) {
            return false;
        }
        return this.tryMatch(text, 0, 0);
    }

    public boolean tryMatch(String text, int element, int offset) {
        int max;
        if (element >= this.elements.size()) {
            return offset == text.length();
        }
        Element el = this.elements.get(element);
        int min = el.minLength();
        for (int i = max = el.maxLength(text.length() - offset); i >= min; --i) {
            if (!el.match(text, offset, i) || !this.tryMatch(text, element + 1, offset + i)) continue;
            return true;
        }
        return false;
    }

    private static class AsterixElement
    implements Element {
        private AsterixElement() {
        }

        public static AsterixElement instance() {
            AsterixElement element = new AsterixElement();
            return element;
        }

        @Override
        public int minLength() {
            return 0;
        }

        @Override
        public int maxLength(int max) {
            return max;
        }

        @Override
        public boolean match(String text, int offset, int length) {
            return true;
        }

        public String toString() {
            return "'*'";
        }
    }

    private static class QuestionmarkElement
    implements Element {
        private QuestionmarkElement() {
        }

        public static QuestionmarkElement instance() {
            QuestionmarkElement element = new QuestionmarkElement();
            return element;
        }

        @Override
        public int minLength() {
            return 1;
        }

        @Override
        public int maxLength(int max) {
            return 1;
        }

        @Override
        public boolean match(String text, int offset, int length) {
            return length == 1;
        }

        public String toString() {
            return "'?'";
        }
    }

    private static class TextElement
    implements Element {
        private String text;
        private int offset;
        private int length;

        private TextElement() {
        }

        public static TextElement instance(String text, int offset, int length) {
            TextElement element = new TextElement();
            element.text = text;
            element.offset = offset;
            element.length = length;
            return element;
        }

        @Override
        public int minLength() {
            return this.length;
        }

        @Override
        public int maxLength(int max) {
            return this.length;
        }

        @Override
        public boolean match(String text, int offset, int length) {
            if (this.length != length) {
                return false;
            }
            if (text.length() < offset + length) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                char cc;
                char c = this.text.charAt(this.offset + i);
                if (c == (cc = text.charAt(offset + i))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.text.substring(this.offset, this.offset + this.length);
        }
    }

    private static interface Element {
        public int minLength();

        public int maxLength(int var1);

        public boolean match(String var1, int var2, int var3);
    }
}

