/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.api.invocation;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java8.util.J8Arrays;
import org.astonbitecode.j4rs.api.NativeInvocation;
import org.astonbitecode.j4rs.api.NativeInvocationBase;
import org.astonbitecode.j4rs.api.dtos.GeneratedArg;
import org.astonbitecode.j4rs.api.dtos.InvocationArg;
import org.astonbitecode.j4rs.api.dtos.InvocationArgGenerator;
import org.astonbitecode.j4rs.api.invocation.JsonInvocationImpl$$Lambda$1;
import org.astonbitecode.j4rs.api.invocation.JsonInvocationImpl$$Lambda$10;
import org.astonbitecode.j4rs.api.invocation.JsonInvocationImpl$$Lambda$11;
import org.astonbitecode.j4rs.api.invocation.JsonInvocationImpl$$Lambda$12;
import org.astonbitecode.j4rs.api.invocation.JsonInvocationImpl$$Lambda$3;
import org.astonbitecode.j4rs.api.invocation.JsonInvocationImpl$$Lambda$4;
import org.astonbitecode.j4rs.api.invocation.JsonInvocationImpl$$Lambda$5;
import org.astonbitecode.j4rs.api.invocation.JsonInvocationImpl$$Lambda$6;
import org.astonbitecode.j4rs.api.invocation.JsonInvocationImpl$$Lambda$7;
import org.astonbitecode.j4rs.api.invocation.JsonInvocationImpl$$Lambda$8;
import org.astonbitecode.j4rs.api.invocation.JsonInvocationImpl$$Lambda$9;
import org.astonbitecode.j4rs.api.invocation.NativeCallbackSupport;
import org.astonbitecode.j4rs.api.invocation.NativeCallbackToRustChannelSupport;
import org.astonbitecode.j4rs.api.value.JsonValueImpl;
import org.astonbitecode.j4rs.errors.InvocationException;
import org.astonbitecode.j4rs.rust.RustPointer;

public class JsonInvocationImpl<T>
extends NativeInvocationBase
implements NativeInvocation<T> {
    private T object;
    private Class<T> clazz;
    private List<Type> classGenTypes = new ArrayList<Type>();
    private InvocationArgGenerator gen = new InvocationArgGenerator();

    public JsonInvocationImpl(Class<T> clazz) {
        this.object = null;
        this.clazz = clazz;
    }

    public JsonInvocationImpl(T instance, Class<T> clazz) {
        this.object = instance;
        this.clazz = clazz;
    }

    public JsonInvocationImpl(T instance, Class<T> clazz, List<Type> classGenTypes) {
        this.object = instance;
        this.clazz = clazz;
        this.classGenTypes = classGenTypes;
    }

    @Override
    public NativeInvocation invoke(String methodName, InvocationArg ... args) {
        try {
            CreatedInstance createdInstance = this.invokeMethod(methodName, this.gen.generateArgObjects(args));
            return new JsonInvocationImpl<Object>(createdInstance.object, createdInstance.clazz, createdInstance.classGenTypes);
        }
        catch (Exception error) {
            throw new InvocationException("While invoking method " + methodName + " of Class " + this.clazz.getName(), error);
        }
    }

    @Override
    public NativeInvocation invokeStatic(String methodName, InvocationArg ... args) {
        try {
            CreatedInstance createdInstance = this.invokeMethod(methodName, this.gen.generateArgObjects(args));
            return new JsonInvocationImpl<Object>(createdInstance.object, createdInstance.clazz, createdInstance.classGenTypes);
        }
        catch (Exception error) {
            throw new InvocationException("Error while invoking method " + methodName + " of Class " + this.clazz.getName(), error);
        }
    }

    @Override
    public void invokeAsync(long functionPointerAddress, String methodName, InvocationArg ... args) {
        if (!NativeCallbackSupport.class.isAssignableFrom(this.clazz)) {
            throw new InvocationException("Cannot invoke asynchronously the class " + this.clazz.getName() + ". The class does not extend the class " + NativeCallbackSupport.class.getName());
        }
        ((NativeCallbackSupport)this.object).initPointer(new RustPointer(functionPointerAddress));
        this.invoke(methodName, args);
    }

    @Override
    public void invokeToChannel(long channelAddress, String methodName, InvocationArg ... args) {
        this.initializeCallbackChannel(channelAddress);
        this.invoke(methodName, args);
    }

    @Override
    public void initializeCallbackChannel(long channelAddress) {
        if (!NativeCallbackToRustChannelSupport.class.isAssignableFrom(this.clazz)) {
            throw new InvocationException("Cannot initialize callback channel for class " + this.clazz.getName() + ". The class does not extend the class " + NativeCallbackToRustChannelSupport.class.getName());
        }
        ((NativeCallbackToRustChannelSupport)this.object).initPointer(new RustPointer(channelAddress));
    }

    @Override
    public NativeInvocation field(String fieldName) {
        try {
            CreatedInstance createdInstance = this.getField(fieldName);
            return new JsonInvocationImpl<Object>(createdInstance.object, createdInstance.clazz);
        }
        catch (Exception error) {
            throw new InvocationException("Error while accessing field " + fieldName + " of Class " + this.clazz.getName(), error);
        }
    }

    public T getObject() {
        return this.object;
    }

    public Class<T> getObjectClass() {
        return this.clazz;
    }

    @Override
    public String getJson() {
        JsonValueImpl jsonValue = new JsonValueImpl(this.object);
        return jsonValue.getJson();
    }

    CreatedInstance getField(String fieldName) throws Exception {
        Field field = this.clazz.getField(fieldName);
        Object fieldObject = field.get(this.object);
        return new CreatedInstance(field.getType(), fieldObject);
    }

    CreatedInstance invokeMethod(String methodName, GeneratedArg[] generatedArgs) throws Exception {
        Class[] argTypes = (Class[])J8Arrays.stream(generatedArgs).map(JsonInvocationImpl$$Lambda$1.lambdaFactory$()).toArray(JsonInvocationImpl$$Lambda$3.lambdaFactory$());
        Object[] argObjects = J8Arrays.stream(generatedArgs).map(JsonInvocationImpl$$Lambda$4.lambdaFactory$()).toArray(JsonInvocationImpl$$Lambda$5.lambdaFactory$());
        Method methodToInvoke = this.findMethodInHierarchy(this.clazz, methodName, argTypes);
        ArrayList<Type> retClassGenTypes = new ArrayList();
        Type returnType = methodToInvoke.getGenericReturnType();
        if (returnType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)returnType;
            retClassGenTypes = Arrays.asList(type.getActualTypeArguments());
        }
        Class<?> invokedMethodReturnType = methodToInvoke.getReturnType();
        Object returnedObject = methodToInvoke.invoke(this.object, argObjects);
        return new CreatedInstance(invokedMethodReturnType, returnedObject, retClassGenTypes);
    }

    Method findMethodInHierarchy(Class clazz, String methodName, Class[] argTypes) throws NoSuchMethodException {
        HashSet<Method> methods = new HashSet<Method>(Arrays.asList(clazz.getDeclaredMethods()));
        Set interfacesMethods = Arrays.stream(clazz.getInterfaces()).map(JsonInvocationImpl$$Lambda$6.lambdaFactory$()).flatMap(JsonInvocationImpl$$Lambda$7.lambdaFactory$()).collect(Collectors.toSet());
        methods.addAll(interfacesMethods);
        List found = methods.stream().filter(JsonInvocationImpl$$Lambda$8.lambdaFactory$(methodName)).filter(JsonInvocationImpl$$Lambda$9.lambdaFactory$(argTypes)).filter(JsonInvocationImpl$$Lambda$10.lambdaFactory$(argTypes)).collect(Collectors.toList());
        if (!found.isEmpty()) {
            return (Method)found.get(0);
        }
        Class superclass = clazz.getSuperclass();
        if (superclass == null) {
            throw new NoSuchMethodException("Method " + methodName + " was not found in " + this.clazz.getName() + " or its ancestors.");
        }
        return this.findMethodInHierarchy(superclass, methodName, argTypes);
    }

    private boolean validateSomeTypeSafety(Class c) {
        List filteredTypeList = this.classGenTypes.stream().filter(JsonInvocationImpl$$Lambda$11.lambdaFactory$(c)).collect(Collectors.toList());
        return this.classGenTypes.isEmpty() || filteredTypeList.isEmpty();
    }

    static /* synthetic */ boolean lambda$validateSomeTypeSafety$9(Class c, Type cgt) {
        return ((Class)cgt).isAssignableFrom(c);
    }

    static /* synthetic */ boolean lambda$findMethodInHierarchy$8(Class[] argTypes, Method m) {
        ArrayList<Boolean> matchedParams = new ArrayList<Boolean>();
        Type[] pts = m.getGenericParameterTypes();
        for (int i = 0; i < argTypes.length; ++i) {
            Type typ = pts[i];
            if (typ instanceof ParameterizedType || typ instanceof WildcardType) {
                matchedParams.add(true);
                continue;
            }
            if (typ instanceof GenericArrayType) {
                matchedParams.add(argTypes[i].isArray());
                continue;
            }
            if (typ instanceof Class) {
                matchedParams.add(typ.equals(argTypes[i]));
                continue;
            }
            matchedParams.add(true);
        }
        return matchedParams.stream().allMatch(JsonInvocationImpl$$Lambda$12.lambdaFactory$());
    }

    static /* synthetic */ boolean lambda$findMethodInHierarchy$7(Class[] argTypes, Method m) {
        return m.getGenericParameterTypes().length == argTypes.length;
    }

    static /* synthetic */ boolean lambda$findMethodInHierarchy$6(String methodName, Method m) {
        return m.getName().equals(methodName);
    }

    static /* synthetic */ Stream lambda$findMethodInHierarchy$5(Method[] m) {
        return Arrays.stream(m);
    }

    static /* synthetic */ Method[] lambda$findMethodInHierarchy$4(Class c) {
        return c.getDeclaredMethods();
    }

    static /* synthetic */ Object[] lambda$invokeMethod$3(int size) {
        return new Object[size];
    }

    static /* synthetic */ Object lambda$invokeMethod$2(GeneratedArg invGeneratedArg) {
        try {
            return invGeneratedArg.getObject();
        }
        catch (Exception error) {
            throw new InvocationException("Cannot parse the parameter objects while invoking method", error);
        }
    }

    static /* synthetic */ Class[] lambda$invokeMethod$1(int size) {
        return new Class[size];
    }

    static /* synthetic */ Class lambda$invokeMethod$0(GeneratedArg invGeneratedArg) {
        try {
            return invGeneratedArg.getClazz();
        }
        catch (Exception error) {
            throw new InvocationException("Cannot parse the parameter types while invoking method", error);
        }
    }

    class CreatedInstance {
        private Class clazz;
        private Object object;
        private List<Type> classGenTypes;

        public CreatedInstance(Class clazz, Object object) {
            this.clazz = clazz;
            this.object = object;
        }

        public CreatedInstance(Class clazz, Object object, List<Type> classGenTypes) {
            this.clazz = clazz;
            this.object = object;
            this.classGenTypes = classGenTypes;
        }

        public Class getClazz() {
            return this.clazz;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

