/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.api.dtos;

import org.astonbitecode.j4rs.api.NativeInvocation;
import org.astonbitecode.j4rs.api.invocation.JsonInvocationImpl;
import org.astonbitecode.j4rs.errors.InvalidArgumentException;
import org.astonbitecode.j4rs.utils.Utils;

public class InvocationArg {
    public static final String CONTENTS_ARRAY = "org.astonbitecode.j4rs.api.dtos.Array";
    private final NativeInvocation nativeInvocation;
    private final String json;
    private boolean serialized;
    private String className;

    public InvocationArg(String className, NativeInvocation nativeInvocation) {
        this.json = null;
        this.className = className;
        this.nativeInvocation = nativeInvocation;
        this.serialized = false;
    }

    public InvocationArg(NativeInvocation nativeInvocation) {
        this.json = null;
        this.className = nativeInvocation.getClass().getName();
        this.nativeInvocation = nativeInvocation;
        this.serialized = false;
    }

    public InvocationArg(String className, String json) {
        this.nativeInvocation = null;
        this.className = className;
        this.json = json;
        this.serialized = true;
    }

    public InvocationArg(String className, Object object) throws ClassNotFoundException {
        this.nativeInvocation = new JsonInvocationImpl<Object>(object, Utils.forNameEnhanced(className));
        this.className = className;
        this.json = null;
        this.serialized = false;
    }

    public boolean isSerialized() {
        return this.serialized;
    }

    public String getClassName() {
        return this.className;
    }

    public NativeInvocation getNativeInvocation() {
        if (this.isSerialized()) {
            throw new InvalidArgumentException("This InvocationArg of class " + this.className + " is created by Rust code.");
        }
        return this.nativeInvocation;
    }

    public String getJson() {
        if (!this.isSerialized()) {
            throw new InvalidArgumentException("This InvocationArg of class " + this.className + " is created by Java code.");
        }
        return this.json;
    }

    public String toString() {
        return "classname:" + this.className + ", serialized:" + this.serialized + ", json:" + this.json + ", nativeInvocation:" + this.nativeInvocation;
    }
}

