/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java8.util.ImmutableCollections;
import java8.util.Lists;
import java8.util.Sets;

final class ColSer
implements Serializable {
    private static final long serialVersionUID = 6309168927139932177L;
    static final int IMM_LIST = 1;
    static final int IMM_SET = 2;
    static final int IMM_MAP = 3;
    private final int tag;
    private transient Object[] array;

    ColSer(int t, Object ... a) {
        this.tag = t;
        this.array = a;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        int len = ois.readInt();
        if (len < 0) {
            throw new InvalidObjectException("negative length " + len);
        }
        Object[] a = new Object[len];
        for (int i = 0; i < len; ++i) {
            a[i] = ois.readObject();
        }
        this.array = a;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeInt(this.array.length);
        for (int i = 0; i < this.array.length; ++i) {
            oos.writeObject(this.array[i]);
        }
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            if (this.array == null) {
                throw new InvalidObjectException("null array");
            }
            switch (this.tag & 0xFF) {
                case 1: {
                    return Lists.of(this.array);
                }
                case 2: {
                    return Sets.of(this.array);
                }
                case 3: {
                    if (this.array.length == 0) {
                        return ImmutableCollections.MapN.EMPTY_MAP;
                    }
                    if (this.array.length == 2) {
                        return new ImmutableCollections.Map1<Object, Object>(this.array[0], this.array[1]);
                    }
                    return new ImmutableCollections.MapN(this.array);
                }
            }
            throw new InvalidObjectException(String.format("invalid flags 0x%x", this.tag));
        }
        catch (NullPointerException ex) {
            throw ColSer.ioe(ex);
        }
        catch (IllegalArgumentException ex) {
            throw ColSer.ioe(ex);
        }
    }

    private static InvalidObjectException ioe(RuntimeException ex) {
        InvalidObjectException ioe = new InvalidObjectException("invalid object");
        ioe.initCause(ex);
        return ioe;
    }
}

