/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java8.util.ArrayPrefixHelpers;
import java8.util.ArraysParallelSortHelpers;
import java8.util.DualPivotQuicksort;
import java8.util.J8Arrays$$Lambda$1;
import java8.util.J8Arrays$$Lambda$2;
import java8.util.J8Arrays$$Lambda$3;
import java8.util.J8Arrays$$Lambda$4;
import java8.util.Objects;
import java8.util.Spliterator;
import java8.util.Spliterators;
import java8.util.TimSort;
import java8.util.concurrent.ForkJoinPool;
import java8.util.function.BinaryOperator;
import java8.util.function.DoubleBinaryOperator;
import java8.util.function.IntBinaryOperator;
import java8.util.function.IntFunction;
import java8.util.function.IntToDoubleFunction;
import java8.util.function.IntToLongFunction;
import java8.util.function.IntUnaryOperator;
import java8.util.function.LongBinaryOperator;
import java8.util.stream.DoubleStream;
import java8.util.stream.IntStream;
import java8.util.stream.IntStreams;
import java8.util.stream.LongStream;
import java8.util.stream.Stream;
import java8.util.stream.StreamSupport;

public final class J8Arrays {
    private static final int MIN_ARRAY_SORT_GRAN = 8192;

    public static <T> Spliterator<T> spliterator(T[] array) {
        return Spliterators.spliterator(array, 1040);
    }

    public static <T> Spliterator<T> spliterator(T[] array, int startInclusive, int endExclusive) {
        return Spliterators.spliterator(array, startInclusive, endExclusive, 1040);
    }

    public static Spliterator.OfInt spliterator(int[] array) {
        return Spliterators.spliterator(array, 1040);
    }

    public static Spliterator.OfInt spliterator(int[] array, int startInclusive, int endExclusive) {
        return Spliterators.spliterator(array, startInclusive, endExclusive, 1040);
    }

    public static Spliterator.OfLong spliterator(long[] array) {
        return Spliterators.spliterator(array, 1040);
    }

    public static Spliterator.OfLong spliterator(long[] array, int startInclusive, int endExclusive) {
        return Spliterators.spliterator(array, startInclusive, endExclusive, 1040);
    }

    public static Spliterator.OfDouble spliterator(double[] array) {
        return Spliterators.spliterator(array, 1040);
    }

    public static Spliterator.OfDouble spliterator(double[] array, int startInclusive, int endExclusive) {
        return Spliterators.spliterator(array, startInclusive, endExclusive, 1040);
    }

    public static <T> Stream<T> stream(T[] array) {
        return J8Arrays.stream(array, 0, array.length);
    }

    public static <T> Stream<T> stream(T[] array, int startInclusive, int endExclusive) {
        return StreamSupport.stream(J8Arrays.spliterator(array, startInclusive, endExclusive), false);
    }

    public static IntStream stream(int[] array) {
        return J8Arrays.stream(array, 0, array.length);
    }

    public static IntStream stream(int[] array, int startInclusive, int endExclusive) {
        return StreamSupport.intStream(J8Arrays.spliterator(array, startInclusive, endExclusive), false);
    }

    public static LongStream stream(long[] array) {
        return J8Arrays.stream(array, 0, array.length);
    }

    public static LongStream stream(long[] array, int startInclusive, int endExclusive) {
        return StreamSupport.longStream(J8Arrays.spliterator(array, startInclusive, endExclusive), false);
    }

    public static DoubleStream stream(double[] array) {
        return J8Arrays.stream(array, 0, array.length);
    }

    public static DoubleStream stream(double[] array, int startInclusive, int endExclusive) {
        return StreamSupport.doubleStream(J8Arrays.spliterator(array, startInclusive, endExclusive), false);
    }

    public static void parallelSort(byte[] a) {
        int p;
        int n = a.length;
        if (n <= 8192 || (p = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(a, 0, n - 1);
        } else {
            int g = n / (p << 2);
            new ArraysParallelSortHelpers.FJByte.Sorter(null, a, new byte[n], 0, n, 0, g <= 8192 ? 8192 : g).invoke();
        }
    }

    public static void parallelSort(byte[] a, int fromIndex, int toIndex) {
        int p;
        J8Arrays.rangeCheck(a.length, fromIndex, toIndex);
        int n = toIndex - fromIndex;
        if (n <= 8192 || (p = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(a, fromIndex, toIndex - 1);
        } else {
            int g = n / (p << 2);
            new ArraysParallelSortHelpers.FJByte.Sorter(null, a, new byte[n], fromIndex, n, 0, g <= 8192 ? 8192 : g).invoke();
        }
    }

    public static void parallelSort(char[] a) {
        int p;
        int n = a.length;
        if (n <= 8192 || (p = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(a, 0, n - 1, null, 0, 0);
        } else {
            int g = n / (p << 2);
            new ArraysParallelSortHelpers.FJChar.Sorter(null, a, new char[n], 0, n, 0, g <= 8192 ? 8192 : g).invoke();
        }
    }

    public static void parallelSort(char[] a, int fromIndex, int toIndex) {
        int p;
        J8Arrays.rangeCheck(a.length, fromIndex, toIndex);
        int n = toIndex - fromIndex;
        if (n <= 8192 || (p = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(a, fromIndex, toIndex - 1, null, 0, 0);
        } else {
            int g = n / (p << 2);
            new ArraysParallelSortHelpers.FJChar.Sorter(null, a, new char[n], fromIndex, n, 0, g <= 8192 ? 8192 : g).invoke();
        }
    }

    public static void parallelSort(short[] a) {
        int p;
        int n = a.length;
        if (n <= 8192 || (p = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(a, 0, n - 1, null, 0, 0);
        } else {
            int g = n / (p << 2);
            new ArraysParallelSortHelpers.FJShort.Sorter(null, a, new short[n], 0, n, 0, g <= 8192 ? 8192 : g).invoke();
        }
    }

    public static void parallelSort(short[] a, int fromIndex, int toIndex) {
        int p;
        J8Arrays.rangeCheck(a.length, fromIndex, toIndex);
        int n = toIndex - fromIndex;
        if (n <= 8192 || (p = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(a, fromIndex, toIndex - 1, null, 0, 0);
        } else {
            int g = n / (p << 2);
            new ArraysParallelSortHelpers.FJShort.Sorter(null, a, new short[n], fromIndex, n, 0, g <= 8192 ? 8192 : g).invoke();
        }
    }

    public static void parallelSort(int[] a) {
        int p;
        int n = a.length;
        if (n <= 8192 || (p = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(a, 0, n - 1, null, 0, 0);
        } else {
            int g = n / (p << 2);
            new ArraysParallelSortHelpers.FJInt.Sorter(null, a, new int[n], 0, n, 0, g <= 8192 ? 8192 : g).invoke();
        }
    }

    public static void parallelSort(int[] a, int fromIndex, int toIndex) {
        int p;
        J8Arrays.rangeCheck(a.length, fromIndex, toIndex);
        int n = toIndex - fromIndex;
        if (n <= 8192 || (p = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(a, fromIndex, toIndex - 1, null, 0, 0);
        } else {
            int g = n / (p << 2);
            new ArraysParallelSortHelpers.FJInt.Sorter(null, a, new int[n], fromIndex, n, 0, g <= 8192 ? 8192 : g).invoke();
        }
    }

    public static void parallelSort(long[] a) {
        int p;
        int n = a.length;
        if (n <= 8192 || (p = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(a, 0, n - 1, null, 0, 0);
        } else {
            int g = n / (p << 2);
            new ArraysParallelSortHelpers.FJLong.Sorter(null, a, new long[n], 0, n, 0, g <= 8192 ? 8192 : g).invoke();
        }
    }

    public static void parallelSort(long[] a, int fromIndex, int toIndex) {
        int p;
        J8Arrays.rangeCheck(a.length, fromIndex, toIndex);
        int n = toIndex - fromIndex;
        if (n <= 8192 || (p = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(a, fromIndex, toIndex - 1, null, 0, 0);
        } else {
            int g = n / (p << 2);
            new ArraysParallelSortHelpers.FJLong.Sorter(null, a, new long[n], fromIndex, n, 0, g <= 8192 ? 8192 : g).invoke();
        }
    }

    public static void parallelSort(float[] a) {
        int p;
        int n = a.length;
        if (n <= 8192 || (p = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(a, 0, n - 1, null, 0, 0);
        } else {
            int g = n / (p << 2);
            new ArraysParallelSortHelpers.FJFloat.Sorter(null, a, new float[n], 0, n, 0, g <= 8192 ? 8192 : g).invoke();
        }
    }

    public static void parallelSort(float[] a, int fromIndex, int toIndex) {
        int p;
        J8Arrays.rangeCheck(a.length, fromIndex, toIndex);
        int n = toIndex - fromIndex;
        if (n <= 8192 || (p = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(a, fromIndex, toIndex - 1, null, 0, 0);
        } else {
            int g = n / (p << 2);
            new ArraysParallelSortHelpers.FJFloat.Sorter(null, a, new float[n], fromIndex, n, 0, g <= 8192 ? 8192 : g).invoke();
        }
    }

    public static void parallelSort(double[] a) {
        int p;
        int n = a.length;
        if (n <= 8192 || (p = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(a, 0, n - 1, null, 0, 0);
        } else {
            int g = n / (p << 2);
            new ArraysParallelSortHelpers.FJDouble.Sorter(null, a, new double[n], 0, n, 0, g <= 8192 ? 8192 : g).invoke();
        }
    }

    public static void parallelSort(double[] a, int fromIndex, int toIndex) {
        int p;
        J8Arrays.rangeCheck(a.length, fromIndex, toIndex);
        int n = toIndex - fromIndex;
        if (n <= 8192 || (p = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(a, fromIndex, toIndex - 1, null, 0, 0);
        } else {
            int g = n / (p << 2);
            new ArraysParallelSortHelpers.FJDouble.Sorter(null, a, new double[n], fromIndex, n, 0, g <= 8192 ? 8192 : g).invoke();
        }
    }

    public static <T extends Comparable<? super T>> void parallelSort(T[] a) {
        int p;
        int n = a.length;
        if (n <= 8192 || (p = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            TimSort.sort(a, 0, n, NaturalOrder.INSTANCE, null, 0, 0);
        } else {
            int g;
            new ArraysParallelSortHelpers.FJObject.Sorter<Object>(null, a, (Comparable[])Array.newInstance(a.getClass().getComponentType(), n), 0, n, 0, (g = n / (p << 2)) <= 8192 ? 8192 : g, NaturalOrder.INSTANCE).invoke();
        }
    }

    public static <T extends Comparable<? super T>> void parallelSort(T[] a, int fromIndex, int toIndex) {
        int p;
        J8Arrays.rangeCheck(a.length, fromIndex, toIndex);
        int n = toIndex - fromIndex;
        if (n <= 8192 || (p = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            TimSort.sort(a, fromIndex, toIndex, NaturalOrder.INSTANCE, null, 0, 0);
        } else {
            int g;
            new ArraysParallelSortHelpers.FJObject.Sorter<Object>(null, a, (Comparable[])Array.newInstance(a.getClass().getComponentType(), n), fromIndex, n, 0, (g = n / (p << 2)) <= 8192 ? 8192 : g, NaturalOrder.INSTANCE).invoke();
        }
    }

    public static <T> void parallelSort(T[] a, Comparator<? super T> cmp) {
        int p;
        int n;
        if (cmp == null) {
            cmp = NaturalOrder.INSTANCE;
        }
        if ((n = a.length) <= 8192 || (p = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            TimSort.sort(a, 0, n, cmp, null, 0, 0);
        } else {
            int g;
            new ArraysParallelSortHelpers.FJObject.Sorter<Object>(null, a, (Object[])Array.newInstance(a.getClass().getComponentType(), n), 0, n, 0, (g = n / (p << 2)) <= 8192 ? 8192 : g, cmp).invoke();
        }
    }

    public static <T> void parallelSort(T[] a, int fromIndex, int toIndex, Comparator<? super T> cmp) {
        int p;
        int n;
        J8Arrays.rangeCheck(a.length, fromIndex, toIndex);
        if (cmp == null) {
            cmp = NaturalOrder.INSTANCE;
        }
        if ((n = toIndex - fromIndex) <= 8192 || (p = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            TimSort.sort(a, fromIndex, toIndex, cmp, null, 0, 0);
        } else {
            int g;
            new ArraysParallelSortHelpers.FJObject.Sorter<Object>(null, a, (Object[])Array.newInstance(a.getClass().getComponentType(), n), fromIndex, n, 0, (g = n / (p << 2)) <= 8192 ? 8192 : g, cmp).invoke();
        }
    }

    public static <T> void setAll(T[] array, IntFunction<? extends T> generator) {
        Objects.requireNonNull(generator);
        for (int i = 0; i < array.length; ++i) {
            array[i] = generator.apply(i);
        }
    }

    public static <T> void parallelSetAll(T[] array, IntFunction<? extends T> generator) {
        Objects.requireNonNull(generator);
        IntStreams.range(0, array.length).parallel().forEach(J8Arrays$$Lambda$1.lambdaFactory$(array, generator));
    }

    public static void setAll(int[] array, IntUnaryOperator generator) {
        Objects.requireNonNull(generator);
        for (int i = 0; i < array.length; ++i) {
            array[i] = generator.applyAsInt(i);
        }
    }

    public static void parallelSetAll(int[] array, IntUnaryOperator generator) {
        Objects.requireNonNull(generator);
        IntStreams.range(0, array.length).parallel().forEach(J8Arrays$$Lambda$2.lambdaFactory$(array, generator));
    }

    public static void setAll(long[] array, IntToLongFunction generator) {
        Objects.requireNonNull(generator);
        for (int i = 0; i < array.length; ++i) {
            array[i] = generator.applyAsLong(i);
        }
    }

    public static void parallelSetAll(long[] array, IntToLongFunction generator) {
        Objects.requireNonNull(generator);
        IntStreams.range(0, array.length).parallel().forEach(J8Arrays$$Lambda$3.lambdaFactory$(array, generator));
    }

    public static void setAll(double[] array, IntToDoubleFunction generator) {
        Objects.requireNonNull(generator);
        for (int i = 0; i < array.length; ++i) {
            array[i] = generator.applyAsDouble(i);
        }
    }

    public static void parallelSetAll(double[] array, IntToDoubleFunction generator) {
        Objects.requireNonNull(generator);
        IntStreams.range(0, array.length).parallel().forEach(J8Arrays$$Lambda$4.lambdaFactory$(array, generator));
    }

    public static <T> void parallelPrefix(T[] array, BinaryOperator<T> op) {
        Objects.requireNonNull(op);
        if (array.length > 0) {
            new ArrayPrefixHelpers.CumulateTask<T>(null, op, array, 0, array.length).invoke();
        }
    }

    public static <T> void parallelPrefix(T[] array, int fromIndex, int toIndex, BinaryOperator<T> op) {
        Objects.requireNonNull(op);
        J8Arrays.rangeCheck(array.length, fromIndex, toIndex);
        if (fromIndex < toIndex) {
            new ArrayPrefixHelpers.CumulateTask<T>(null, op, array, fromIndex, toIndex).invoke();
        }
    }

    public static void parallelPrefix(long[] array, LongBinaryOperator op) {
        Objects.requireNonNull(op);
        if (array.length > 0) {
            new ArrayPrefixHelpers.LongCumulateTask(null, op, array, 0, array.length).invoke();
        }
    }

    public static void parallelPrefix(long[] array, int fromIndex, int toIndex, LongBinaryOperator op) {
        Objects.requireNonNull(op);
        J8Arrays.rangeCheck(array.length, fromIndex, toIndex);
        if (fromIndex < toIndex) {
            new ArrayPrefixHelpers.LongCumulateTask(null, op, array, fromIndex, toIndex).invoke();
        }
    }

    public static void parallelPrefix(double[] array, DoubleBinaryOperator op) {
        Objects.requireNonNull(op);
        if (array.length > 0) {
            new ArrayPrefixHelpers.DoubleCumulateTask(null, op, array, 0, array.length).invoke();
        }
    }

    public static void parallelPrefix(double[] array, int fromIndex, int toIndex, DoubleBinaryOperator op) {
        Objects.requireNonNull(op);
        J8Arrays.rangeCheck(array.length, fromIndex, toIndex);
        if (fromIndex < toIndex) {
            new ArrayPrefixHelpers.DoubleCumulateTask(null, op, array, fromIndex, toIndex).invoke();
        }
    }

    public static void parallelPrefix(int[] array, IntBinaryOperator op) {
        Objects.requireNonNull(op);
        if (array.length > 0) {
            new ArrayPrefixHelpers.IntCumulateTask(null, op, array, 0, array.length).invoke();
        }
    }

    public static void parallelPrefix(int[] array, int fromIndex, int toIndex, IntBinaryOperator op) {
        Objects.requireNonNull(op);
        J8Arrays.rangeCheck(array.length, fromIndex, toIndex);
        if (fromIndex < toIndex) {
            new ArrayPrefixHelpers.IntCumulateTask(null, op, array, fromIndex, toIndex).invoke();
        }
    }

    public static <T> T[] toArray(Collection<T> col, IntFunction<T[]> generator) {
        return col.toArray(generator.apply(0));
    }

    private static void rangeCheck(int arrayLength, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLength) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    private J8Arrays() {
    }

    static /* synthetic */ void lambda$parallelSetAll$166(double[] dArray, IntToDoubleFunction intToDoubleFunction, int i) {
        dArray[i] = intToDoubleFunction.applyAsDouble(i);
    }

    static /* synthetic */ void lambda$parallelSetAll$165(long[] lArray, IntToLongFunction intToLongFunction, int i) {
        lArray[i] = intToLongFunction.applyAsLong(i);
    }

    static /* synthetic */ void lambda$parallelSetAll$164(int[] nArray, IntUnaryOperator intUnaryOperator, int i) {
        nArray[i] = intUnaryOperator.applyAsInt(i);
    }

    static /* synthetic */ void lambda$parallelSetAll$163(Object[] objectArray, IntFunction intFunction, int i) {
        objectArray[i] = intFunction.apply(i);
    }

    static final class NaturalOrder
    implements Comparator<Object> {
        static final NaturalOrder INSTANCE = new NaturalOrder();

        NaturalOrder() {
        }

        @Override
        public int compare(Object first, Object second) {
            return ((Comparable)first).compareTo(second);
        }
    }
}

