/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.util.Comparator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import java8.util.Objects;
import java8.util.Spliterator;
import java8.util.Spliterators;
import java8.util.UnsafeAccess;
import java8.util.function.Consumer;
import sun.misc.Unsafe;

final class LBQSpliterator<E>
implements Spliterator<E> {
    private static final int MAX_BATCH = 0x2000000;
    private final LinkedBlockingQueue<E> queue;
    private final ReentrantLock putLock;
    private final ReentrantLock takeLock;
    private Object current;
    private int batch;
    private boolean exhausted;
    private long est;
    private static final Unsafe U = UnsafeAccess.unsafe;
    private static final long HEAD_OFF;
    private static final long NODE_ITEM_OFF;
    private static final long NODE_NEXT_OFF;
    private static final long PUT_LOCK_OFF;
    private static final long TAKE_LOCK_OFF;

    private LBQSpliterator(LinkedBlockingQueue<E> queue) {
        this.queue = queue;
        this.est = queue.size();
        this.putLock = LBQSpliterator.getPutLock(queue);
        this.takeLock = LBQSpliterator.getTakeLock(queue);
    }

    static <T> Spliterator<T> spliterator(LinkedBlockingQueue<T> queue) {
        return new LBQSpliterator<T>(queue);
    }

    Object succ(Object p) {
        return p == (p = LBQSpliterator.getNextNode(p)) ? LBQSpliterator.getHeadNext(this.queue) : p;
    }

    @Override
    public int characteristics() {
        return 4368;
    }

    @Override
    public long estimateSize() {
        return this.est;
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        if (!this.exhausted) {
            this.exhausted = true;
            Object p = this.current;
            this.current = null;
            this.forEachFrom(action, p);
        }
    }

    @Override
    public Comparator<? super E> getComparator() {
        return Spliterators.getComparator(this);
    }

    @Override
    public long getExactSizeIfKnown() {
        return Spliterators.getExactSizeIfKnown(this);
    }

    @Override
    public boolean hasCharacteristics(int characteristics) {
        return Spliterators.hasCharacteristics(this, characteristics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        if (!this.exhausted) {
            Object e = null;
            this.fullyLock();
            try {
                Object p = this.current;
                if (p != null || (p = LBQSpliterator.getHeadNext(this.queue)) != null) {
                    do {
                        e = LBQSpliterator.getNodeItem(p);
                        p = this.succ(p);
                    } while (e == null && p != null);
                }
                if ((this.current = p) == null) {
                    this.exhausted = true;
                }
            }
            finally {
                this.fullyUnlock();
            }
            if (e != null) {
                action.accept(e);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Spliterator<E> trySplit() {
        Object h;
        LinkedBlockingQueue<E> q = this.queue;
        if (!(this.exhausted || (h = this.current) == null && (h = LBQSpliterator.getHeadNext(q)) == null || LBQSpliterator.getNextNode(h) == null)) {
            int n = this.batch = Math.min(this.batch + 1, 0x2000000);
            Object[] a = new Object[n];
            int i = 0;
            Object p = this.current;
            this.fullyLock();
            try {
                if (p != null || (p = LBQSpliterator.getHeadNext(q)) != null) {
                    while (p != null && i < n) {
                        a[i] = LBQSpliterator.getNodeItem(p);
                        if (a[i] != null) {
                            ++i;
                        }
                        p = this.succ(p);
                    }
                }
            }
            finally {
                this.fullyUnlock();
            }
            this.current = p;
            if (this.current == null) {
                this.est = 0L;
                this.exhausted = true;
            } else if ((this.est -= (long)i) < 0L) {
                this.est = 0L;
            }
            if (i > 0) {
                return Spliterators.spliterator(a, 0, i, 4368);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forEachFrom(Consumer<? super E> action, Object p) {
        int n;
        int batchSize = 64;
        Object[] es = null;
        int len = 0;
        do {
            this.fullyLock();
            try {
                if (es == null) {
                    if (p == null) {
                        p = LBQSpliterator.getHeadNext(this.queue);
                    }
                    Object q = p;
                    while (q != null && (LBQSpliterator.getNodeItem(q) == null || ++len != 64)) {
                        q = this.succ(q);
                    }
                    es = new Object[len];
                }
                n = 0;
                while (p != null && n < len) {
                    es[n] = LBQSpliterator.getNodeItem(p);
                    if (es[n] != null) {
                        ++n;
                    }
                    p = this.succ(p);
                }
            }
            finally {
                this.fullyUnlock();
            }
            for (int i = 0; i < n; ++i) {
                Object e = es[i];
                action.accept(e);
            }
        } while (n > 0 && p != null);
    }

    private void fullyLock() {
        this.putLock.lock();
        this.takeLock.lock();
    }

    private void fullyUnlock() {
        this.takeLock.unlock();
        this.putLock.unlock();
    }

    private static ReentrantLock getPutLock(LinkedBlockingQueue<?> queue) {
        return (ReentrantLock)U.getObject(queue, PUT_LOCK_OFF);
    }

    private static ReentrantLock getTakeLock(LinkedBlockingQueue<?> queue) {
        return (ReentrantLock)U.getObject(queue, TAKE_LOCK_OFF);
    }

    private static <T> Object getHeadNext(LinkedBlockingQueue<T> queue) {
        return LBQSpliterator.getNextNode(U.getObject(queue, HEAD_OFF));
    }

    private static Object getNextNode(Object node) {
        return U.getObject(node, NODE_NEXT_OFF);
    }

    private static <T> T getNodeItem(Object node) {
        return (T)U.getObject(node, NODE_ITEM_OFF);
    }

    static {
        try {
            Class<?> nc = Class.forName("java.util.concurrent.LinkedBlockingQueue$Node");
            HEAD_OFF = U.objectFieldOffset(LinkedBlockingQueue.class.getDeclaredField("head"));
            NODE_ITEM_OFF = U.objectFieldOffset(nc.getDeclaredField("item"));
            NODE_NEXT_OFF = U.objectFieldOffset(nc.getDeclaredField("next"));
            PUT_LOCK_OFF = U.objectFieldOffset(LinkedBlockingQueue.class.getDeclaredField("putLock"));
            TAKE_LOCK_OFF = U.objectFieldOffset(LinkedBlockingQueue.class.getDeclaredField("takeLock"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

