/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java8.util.ImmutableCollections;
import java8.util.Objects;
import java8.util.Spliterator;
import java8.util.Spliterators;
import java8.util.function.UnaryOperator;

public final class Lists {
    public static <E> void sort(List<E> list, Comparator<? super E> c) {
        Collections.sort(list, c);
    }

    public static <E> void replaceAll(List<E> list, UnaryOperator<E> operator) {
        Objects.requireNonNull(list);
        Objects.requireNonNull(operator);
        ListIterator li = list.listIterator();
        while (li.hasNext()) {
            li.set(operator.apply(li.next()));
        }
    }

    public static <E> Spliterator<E> spliterator(List<E> list) {
        return Spliterators.spliterator(list);
    }

    public static <E> List<E> of() {
        return ImmutableCollections.ListN.EMPTY_LIST;
    }

    public static <E> List<E> of(E e1) {
        return new ImmutableCollections.List12<E>(e1);
    }

    public static <E> List<E> of(E e1, E e2) {
        return new ImmutableCollections.List12<E>(e1, e2);
    }

    public static <E> List<E> of(E e1, E e2, E e3) {
        return new ImmutableCollections.ListN<Object>(e1, e2, e3);
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4) {
        return new ImmutableCollections.ListN<Object>(e1, e2, e3, e4);
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4, E e5) {
        return new ImmutableCollections.ListN<Object>(e1, e2, e3, e4, e5);
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4, E e5, E e6) {
        return new ImmutableCollections.ListN<Object>(e1, e2, e3, e4, e5, e6);
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E e7) {
        return new ImmutableCollections.ListN<Object>(e1, e2, e3, e4, e5, e6, e7);
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E e7, E e8) {
        return new ImmutableCollections.ListN<Object>(e1, e2, e3, e4, e5, e6, e7, e8);
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9) {
        return new ImmutableCollections.ListN<Object>(e1, e2, e3, e4, e5, e6, e7, e8, e9);
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9, E e10) {
        return new ImmutableCollections.ListN<Object>(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10);
    }

    public static <E> List<E> of(E ... elements) {
        switch (elements.length) {
            case 0: {
                List<?> list = ImmutableCollections.ListN.EMPTY_LIST;
                return list;
            }
            case 1: {
                return new ImmutableCollections.List12<E>(elements[0]);
            }
            case 2: {
                return new ImmutableCollections.List12<E>(elements[0], elements[1]);
            }
        }
        return new ImmutableCollections.ListN<E>(elements);
    }

    public static <E> List<E> copyOf(Collection<? extends E> coll) {
        return ImmutableCollections.listCopy(coll);
    }

    private Lists() {
    }
}

