/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.api.deploy;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;

public class SimpleMavenDeployer {
    private static final String MAVEN_CENTRAL = "https://repo.maven.apache.org/maven2";
    private final String M2_CACHE = System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository";
    private final String repoBase;
    private final boolean checkLocalCache;
    private final String deployTarget;

    public SimpleMavenDeployer() {
        this(MAVEN_CENTRAL, true, ".");
    }

    public SimpleMavenDeployer(String deployTarget) {
        this(MAVEN_CENTRAL, true, deployTarget);
    }

    public SimpleMavenDeployer(String repoBase, String deployTarget) {
        this(repoBase, true, deployTarget);
    }

    public SimpleMavenDeployer(String repoBase, boolean checkLocalCache, String deployTarget) {
        this.repoBase = repoBase;
        this.checkLocalCache = checkLocalCache;
        this.deployTarget = deployTarget;
        new File(deployTarget).mkdirs();
    }

    public void deploy(String groupId, String artifactId, String version, String qualifier) throws IOException {
        String jarName = this.generateArtifactName(artifactId, version, qualifier);
        String urlString = this.generateUrlTagret(groupId, artifactId, version, jarName);
        boolean searchRemoteRepo = true;
        if (!this.artifactExists(groupId, artifactId, version, qualifier)) {
            if (this.checkLocalCache) {
                try {
                    this.deployFromLocalCache(groupId, artifactId, version, qualifier);
                    searchRemoteRepo = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (searchRemoteRepo) {
                // empty if block
            }
        }
    }

    private boolean artifactExists(String groupId, String artifactId, String version, String qualifier) {
        String jarName = this.generateArtifactName(artifactId, version, qualifier);
        String pathString = this.deployTarget + File.separator + jarName;
        return new File(pathString).exists();
    }

    void deployFromLocalCache(String groupId, String artifactId, String version, String qualifier) throws MalformedURLException, IOException {
        String jarName = this.generateArtifactName(artifactId, version, qualifier);
        String pathString = this.generatePathTagret(this.M2_CACHE, groupId, artifactId, version, jarName);
    }

    String generateArtifactName(String artifactId, String version, String qualifier) {
        StringBuilder jarName = new StringBuilder(String.format("%s-%s", artifactId, version));
        if (qualifier != null && !qualifier.isEmpty()) {
            jarName.append("-").append(qualifier);
        }
        jarName.append(".jar");
        return jarName.toString();
    }

    String generateUrlTagret(String groupId, String artifactId, String version, String jarName) {
        return String.format("%s/%s/%s/%s/%s", this.repoBase, groupId.replace(".", "/"), artifactId, version, jarName);
    }

    String generatePathTagret(String base, String groupId, String artifactId, String version, String jarName) {
        return String.format("%s%s%s%s%s%s%s%s%s", base, File.separator, groupId.replace(".", File.separator), File.separator, artifactId, File.separator, version, File.separator, jarName);
    }

    public String getRepoBase() {
        return this.repoBase;
    }
}

