/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.api.dtos;

import org.astonbitecode.j4rs.api.NativeInvocation;
import org.astonbitecode.j4rs.errors.InvalidArgumentException;

public class InvocationArg {
    public static final String CONTENTS_ARRAY = "org.astonbitecode.j4rs.api.dtos.Array";
    private NativeInvocation nativeInvocation;
    private String json;
    private String argFrom;
    private String className;
    private static String JAVA = "java";
    private static String RUST = "rust";

    public InvocationArg(String className, NativeInvocation nativeInvocation) {
        this.className = className;
        this.nativeInvocation = nativeInvocation;
        this.argFrom = JAVA;
    }

    public InvocationArg(NativeInvocation nativeInvocation) {
        this.className = nativeInvocation.getClass().getName();
        this.nativeInvocation = nativeInvocation;
        this.argFrom = JAVA;
    }

    public InvocationArg(String className, String json) {
        this.className = className;
        this.json = json;
        this.argFrom = RUST;
    }

    public String getArgFrom() {
        return this.argFrom;
    }

    public String getClassName() {
        return this.className;
    }

    public NativeInvocation getNativeInvocation() {
        if (this.argFrom.equals(RUST)) {
            throw new InvalidArgumentException("This InvocationArg of class " + this.className + " is created by Rust code.");
        }
        return this.nativeInvocation;
    }

    public String getJson() {
        if (this.argFrom.equals(JAVA)) {
            throw new InvalidArgumentException("This InvocationArg of class " + this.className + " is created by Java code.");
        }
        return this.json;
    }

    public String toString() {
        return "classname:" + this.className + ", argFrom:" + this.argFrom + ", json:" + this.json + ", nativeInvocation:" + this.nativeInvocation;
    }
}

