/*
 * Decompiled with CFR 0.152.
 */
package org.astonbitecode.j4rs.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java8.util.J8Arrays;
import org.astonbitecode.j4rs.errors.JsonCodecException;
import org.astonbitecode.j4rs.json.Codec$$Lambda$1;

public class Codec {
    private static final String RUST_FIELD = "Rust";
    private static final String JSON_FIELD = "json";
    private static final String CLASS_NAME_FIELD = "class_name";
    private ObjectMapper mapper = new ObjectMapper();
    TypeReference<Map<String, Object>[]> typeRef = new TypeReference<Map<String, Object>[]>(){};

    public <T> T decode(String json, String className) throws ClassNotFoundException, IOException {
        Class<?> clazz = Class.forName(className);
        Object obj = this.mapper.readValue(json, clazz);
        return (T)obj;
    }

    public String encode(Object obj) throws JsonProcessingException {
        return this.mapper.writeValueAsString(obj);
    }

    public Object[] decodeArrayContents(String json) throws IOException {
        Object[] array = (Map[])this.mapper.readValue(json, this.typeRef);
        return J8Arrays.stream((Object[])array).map(Codec$$Lambda$1.lambdaFactory$(this)).toArray();
    }

    private <U> U retrieveFromMap(Map<String, Object> map) throws ClassNotFoundException, IOException {
        Map innerMap = (Map)map.get(RUST_FIELD);
        if (innerMap == null) {
            throw new JsonCodecException("Cannot create InvocationArg object form Map '" + map + "'");
        }
        String retrievedClassName = (String)innerMap.get(CLASS_NAME_FIELD);
        String retrievedJson = (String)innerMap.get(JSON_FIELD);
        if (retrievedClassName == null || retrievedJson == null) {
            throw new JsonCodecException("Cannot create InvocationArg object form the JSON '" + retrievedJson + "'");
        }
        return (U)this.decode(retrievedJson, retrievedClassName);
    }

    static /* synthetic */ Object lambda$decodeArrayContents$0(Codec this_, Map elem) {
        try {
            return this_.retrieveFromMap(elem);
        }
        catch (Exception error) {
            throw new JsonCodecException("Error while retrieving Array", error);
        }
    }
}

