/*
 * Decompiled with CFR 0.152.
 */
package io.packable;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;

class ByteArrayPool {
    private static final int DEFAULT_ARRAY_LEN_SHIFT = 12;
    private static final int DEFAULT_ARRAY_SIZE = 4096;
    private static final int DEFAULT_CAPACITY = 8;
    private static int defaultCount = 0;
    private static final byte[][] defaultArrays = new byte[8][];
    private static final int MAX_ARRAY_SHIFT = 22;
    private static final int MAX_ARRAY_SIZE = 0x400000;
    private static final int TEMP_ARRAYS_CAPACITY = 10;
    private static final LinkedList<WeakReference<byte[]>>[] tempArrays = new LinkedList[10];

    ByteArrayPool() {
    }

    static byte[] getArray() {
        return ByteArrayPool.getArray(4096);
    }

    static byte[] getArray(int len) {
        if (len > 0x40000000) {
            throw new IllegalArgumentException("desire capacity over limit, len:" + len);
        }
        if (len <= 4096) {
            return ByteArrayPool.getDefaultArray();
        }
        if (len > 0x400000) {
            return new byte[len];
        }
        return ByteArrayPool.getTempArray(ByteArrayPool.getIndex(len));
    }

    private static int getIndex(int len) {
        if (len <= 4096) {
            return 0;
        }
        int n = 0;
        int a = len - 1 >> 12;
        while (a != 0) {
            a >>>= 1;
            ++n;
        }
        return n;
    }

    static void recycleArray(byte[] bytes) {
        int index;
        int capacity;
        if (bytes == null) {
            return;
        }
        int len = bytes.length;
        if (len == 4096) {
            ByteArrayPool.recycleDefaultArray(bytes);
        } else if (len > 4096 && len <= 0x400000 && len == (capacity = 1 << (index = ByteArrayPool.getIndex(len)) + 12)) {
            ByteArrayPool.recycleTempArray(index, bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getDefaultArray() {
        byte[][] byArray = defaultArrays;
        synchronized (defaultArrays) {
            if (defaultCount > 0) {
                byte[] a = defaultArrays[--defaultCount];
                ByteArrayPool.defaultArrays[ByteArrayPool.defaultCount] = null;
                // ** MonitorExit[var0] (shouldn't be in output)
                return a;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return new byte[4096];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recycleDefaultArray(byte[] bytes) {
        byte[][] byArray = defaultArrays;
        synchronized (defaultArrays) {
            if (defaultCount < 8) {
                ByteArrayPool.defaultArrays[ByteArrayPool.defaultCount++] = bytes;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getTempArray(int index) {
        LinkedList<WeakReference<byte[]>>[] linkedListArray = tempArrays;
        synchronized (tempArrays) {
            int start = index - 1;
            int end = Math.min(start + 3, 10);
            for (int j = start; j < end; ++j) {
                LinkedList<WeakReference<byte[]>> list = tempArrays[j];
                if (list == null || list.isEmpty()) continue;
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    WeakReference ref = (WeakReference)it.next();
                    it.remove();
                    byte[] bytes = (byte[])ref.get();
                    if (bytes == null) continue;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return bytes;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new byte[1 << index + 12];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void recycleTempArray(int index, byte[] bytes) {
        int i = index - 1;
        if (i >= 10) return;
        LinkedList<WeakReference<byte[]>>[] linkedListArray = tempArrays;
        synchronized (tempArrays) {
            LinkedList<WeakReference<Object>> list = tempArrays[i];
            if (list == null) {
                ByteArrayPool.tempArrays[i] = list = new LinkedList();
            }
            list.add(new WeakReference<byte[]>(bytes));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }
}

