/*
 * Decompiled with CFR 0.152.
 */
package io.packable;

final class DecodeBuffer {
    final byte[] hb;
    int position;
    int limit;

    DecodeBuffer(byte[] array, int offset, int length) {
        this.hb = array;
        this.position = offset;
        this.limit = offset + length;
    }

    void checkBound(int offset, int len) {
        if (offset + len > this.limit) {
            throw new IndexOutOfBoundsException("buffer out of bound");
        }
    }

    public boolean hasRemaining() {
        return this.position < this.limit;
    }

    public byte readByte() {
        return this.hb[this.position++];
    }

    public short readShort() {
        return (short)(this.hb[this.position++] & 0xFF | this.hb[this.position++] << 8);
    }

    public int readInt() {
        int value = this.hb[this.position] & 0xFF | (this.hb[this.position + 1] & 0xFF) << 8 | (this.hb[this.position + 2] & 0xFF) << 16 | this.hb[this.position + 3] << 24;
        this.position += 4;
        return value;
    }

    public int readVarInt32() {
        int x;
        if ((x = this.hb[this.position++]) >> 7 == 0) {
            return x;
        }
        if ((x = x & 0x7F | this.hb[this.position++] << 7) >> 14 == 0) {
            return x;
        }
        if ((x = x & 0x3FFF | this.hb[this.position++] << 14) >> 21 == 0) {
            return x;
        }
        if ((x = x & 0x1FFFFF | this.hb[this.position++] << 21) >> 28 == 0) {
            return x;
        }
        x = x & 0xFFFFFFF | this.hb[this.position++] << 28;
        return x;
    }

    public long readLong(int i) {
        return (long)this.hb[i] & 0xFFL | ((long)this.hb[i + 1] & 0xFFL) << 8 | ((long)this.hb[i + 2] & 0xFFL) << 16 | ((long)this.hb[i + 3] & 0xFFL) << 24 | ((long)this.hb[i + 4] & 0xFFL) << 32 | ((long)this.hb[i + 5] & 0xFFL) << 40 | ((long)this.hb[i + 6] & 0xFFL) << 48 | (long)this.hb[i + 7] << 56;
    }

    public long readLong() {
        long value = this.readLong(this.position);
        this.position += 8;
        return value;
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public void readBytes(byte[] bytes) {
        int len = bytes.length;
        System.arraycopy(this.hb, this.position, bytes, 0, len);
        this.position += len;
    }
}

