/*
 * Decompiled with CFR 0.152.
 */
package io.packable;

import io.packable.ByteArrayPool;

final class EncodeBuffer {
    private static volatile int sMaxAllocated = 4096;
    byte[] hb;
    int position;

    EncodeBuffer(byte[] array) {
        this.hb = array;
        this.position = 0;
    }

    public void writeByte(byte v) {
        this.hb[this.position++] = v;
    }

    public void writeShort(int i, short v) {
        this.hb[i] = (byte)v;
        this.hb[i + 1] = (byte)(v >> 8);
    }

    public void writeShort(short v) {
        this.hb[this.position] = (byte)v;
        this.hb[this.position + 1] = (byte)(v >> 8);
        this.position += 2;
    }

    public void writeInt(int v) {
        this.hb[this.position] = (byte)v;
        this.hb[this.position + 1] = (byte)(v >> 8);
        this.hb[this.position + 2] = (byte)(v >> 16);
        this.hb[this.position + 3] = (byte)(v >> 24);
        this.position += 4;
    }

    public void writeInt(int i, int v) {
        this.hb[i] = (byte)v;
        this.hb[i + 1] = (byte)(v >> 8);
        this.hb[i + 2] = (byte)(v >> 16);
        this.hb[i + 3] = (byte)(v >> 24);
    }

    public static int getVarInt32Size(int v) {
        if (v >> 7 == 0) {
            return 1;
        }
        if (v >> 14 == 0) {
            return 2;
        }
        if (v >> 21 == 0) {
            return 3;
        }
        if (v >> 28 == 0) {
            return 4;
        }
        return 5;
    }

    public void writeVarIntNegative1() {
        this.hb[this.position] = -1;
        this.hb[this.position + 1] = -1;
        this.hb[this.position + 2] = -1;
        this.hb[this.position + 3] = -1;
        this.hb[this.position + 4] = 15;
        this.position += 4;
    }

    public int writeVarInt32(int i, int v) {
        while ((v & 0xFFFFFF80) != 0) {
            this.hb[i++] = (byte)(v & 0x7F | 0x80);
            v >>>= 7;
        }
        this.hb[i++] = (byte)v;
        return i;
    }

    public void writeVarInt32(int v) {
        this.position = this.writeVarInt32(this.position, v);
    }

    public void writeLong(long v) {
        this.hb[this.position] = (byte)v;
        this.hb[this.position + 1] = (byte)(v >> 8);
        this.hb[this.position + 2] = (byte)(v >> 16);
        this.hb[this.position + 3] = (byte)(v >> 24);
        this.hb[this.position + 4] = (byte)(v >> 32);
        this.hb[this.position + 5] = (byte)(v >> 40);
        this.hb[this.position + 6] = (byte)(v >> 48);
        this.hb[this.position + 7] = (byte)(v >> 56);
        this.position += 8;
    }

    public void writeFloat(float v) {
        this.writeInt(Float.floatToRawIntBits(v));
    }

    public void writeDouble(double v) {
        this.writeLong(Double.doubleToRawLongBits(v));
    }

    public void writeBytes(byte[] src) {
        int len = src.length;
        if (len > 0) {
            System.arraycopy(src, 0, this.hb, this.position, len);
            this.position += len;
        }
    }

    void checkCapacity(int expandSize) {
        int capacity = this.hb.length;
        int desSize = this.position + expandSize;
        if (desSize <= 0) {
            throw new IllegalStateException("desire capacity overflow");
        }
        if (desSize > capacity) {
            int newSize;
            if (desSize > 0x40000000) {
                throw new IllegalStateException("desire capacity over limit");
            }
            for (newSize = capacity << 1; desSize > newSize; newSize <<= 1) {
            }
            int doubleLimit = Math.min(sMaxAllocated, 0x100000);
            if (newSize < doubleLimit) {
                newSize <<= 1;
            }
            if (newSize > sMaxAllocated) {
                sMaxAllocated = newSize;
            }
            byte[] oldArray = this.hb;
            byte[] newArray = ByteArrayPool.getArray(newSize);
            System.arraycopy(oldArray, 0, newArray, 0, this.position);
            this.hb = newArray;
            ByteArrayPool.recycleArray(oldArray);
        }
    }
}

