/*
 * Decompiled with CFR 0.152.
 */
package io.packable;

class LongArrayPool {
    private static final int DEFAULT_SIZE = 32;
    private static final int DEFAULT_CAPACITY = 16;
    private static int defaultCount = 0;
    private static final long[][] defaultArrays = new long[16][];
    private static final int SECOND_SIZE = 64;
    private static final int SECOND_CAPACITY = 4;
    private static int secondCount = 0;
    private static final long[][] secondArrays = new long[4][];

    LongArrayPool() {
    }

    static long[] getArray(int size) {
        if (size <= 32) {
            return LongArrayPool.getDefaultArray();
        }
        if (size <= 64) {
            return LongArrayPool.getSecondArray();
        }
        return new long[size <= 128 ? 128 : 256];
    }

    static void recycleArray(long[] a) {
        if (a == null) {
            return;
        }
        int size = a.length;
        if (size == 32) {
            LongArrayPool.recycleDefaultArray(a);
        } else if (size == 64) {
            LongArrayPool.recycleSecondArray(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long[] getDefaultArray() {
        long[][] lArray = defaultArrays;
        synchronized (defaultArrays) {
            if (defaultCount > 0) {
                long[] a = defaultArrays[--defaultCount];
                LongArrayPool.defaultArrays[LongArrayPool.defaultCount] = null;
                // ** MonitorExit[var0] (shouldn't be in output)
                return a;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return new long[32];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recycleDefaultArray(long[] a) {
        long[][] lArray = defaultArrays;
        synchronized (defaultArrays) {
            if (defaultCount < 16) {
                LongArrayPool.defaultArrays[LongArrayPool.defaultCount++] = a;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long[] getSecondArray() {
        long[][] lArray = secondArrays;
        synchronized (secondArrays) {
            if (secondCount > 0) {
                long[] a = secondArrays[--secondCount];
                LongArrayPool.secondArrays[LongArrayPool.secondCount] = null;
                // ** MonitorExit[var0] (shouldn't be in output)
                return a;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return new long[64];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recycleSecondArray(long[] a) {
        long[][] lArray = secondArrays;
        synchronized (secondArrays) {
            if (secondCount < 4) {
                LongArrayPool.secondArrays[LongArrayPool.secondCount++] = a;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

