/*
 * Decompiled with CFR 0.152.
 */
package io.packable;

import io.packable.CharArrayPool;
import io.packable.DecodeBuffer;
import io.packable.LongArrayPool;
import io.packable.PackConfig;
import io.packable.TypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PackDecoder {
    private static final long NULL_FLAG = -1L;
    private static final long INT_MASK = 0xFFFFFFFFL;
    private static final int DECODER_POOL_CAPACITY = 8;
    private final DecoderPool pool;
    private final DecodeBuffer buffer;
    private long[] infoArray;
    private int maxIndex = -1;
    private boolean recycled = false;

    public PackDecoder(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public PackDecoder(byte[] bytes, int offset, int len) {
        this(new DecodeBuffer(bytes, offset, len), new DecoderPool(bytes));
        if (bytes == null) {
            throw new IllegalArgumentException("bytes is null");
        }
        if (bytes.length > 0x40000000) {
            throw new IllegalArgumentException("buffer size over limit");
        }
        if (offset + len > bytes.length) {
            throw new IllegalArgumentException("out of range, size:" + bytes.length + " offset:" + offset + " length:" + len);
        }
    }

    private PackDecoder(DecodeBuffer buffer, DecoderPool pool) {
        this.buffer = buffer;
        this.pool = pool;
    }

    public static <T> T decode(byte[] bytes, TypeAdapter<T> adapter) {
        return PackDecoder.decode(bytes, 0, bytes.length, adapter);
    }

    public static <T> T decode(byte[] bytes, int offset, int len, TypeAdapter<T> adapter) {
        PackDecoder decoder = new PackDecoder(bytes, offset, len);
        T t = adapter.decode(decoder);
        decoder.recycle();
        return t;
    }

    public static int[] decodeIntArray(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return new int[0];
        }
        DecodeBuffer buffer = new DecodeBuffer(bytes, 0, bytes.length);
        int size = buffer.readVarInt32();
        return PackDecoder.wrapIntArray(buffer, size);
    }

    public static long[] decodeLongArray(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return new long[0];
        }
        DecodeBuffer buffer = new DecodeBuffer(bytes, 0, bytes.length);
        int size = buffer.readVarInt32();
        return PackDecoder.wrapLongArray(buffer, size);
    }

    public static List<String> decodeStringList(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return new ArrayList<String>();
        }
        PackDecoder decoder = new PackDecoder(bytes);
        DecodeBuffer buffer = decoder.buffer;
        int size = buffer.readVarInt32();
        ArrayList<String> value = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            value.add(decoder.takeString());
        }
        decoder.recycle();
        return value;
    }

    public static <T> List<T> decodeObjectList(byte[] bytes, TypeAdapter<T> adapter) {
        if (bytes == null || bytes.length == 0) {
            return new ArrayList();
        }
        PackDecoder decoder = new PackDecoder(bytes);
        DecodeBuffer buffer = decoder.buffer;
        int size = buffer.readVarInt32();
        ArrayList<T> value = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            value.add(decoder.takeObject(adapter));
        }
        decoder.recycle();
        return value;
    }

    private static int[] wrapIntArray(DecodeBuffer buffer, int n) {
        int[] value = new int[n];
        for (int i = 0; i < n; ++i) {
            value[i] = buffer.readInt();
        }
        return value;
    }

    private static long[] wrapLongArray(DecodeBuffer buffer, int n) {
        long[] value = new long[n];
        for (int i = 0; i < n; ++i) {
            value[i] = buffer.readLong();
        }
        return value;
    }

    private void checkState() {
        if (this.recycled) {
            throw new IllegalStateException("Decoder had been recycled");
        }
    }

    private void recycle() {
        this.checkState();
        CharArrayPool.recycleArray(this.pool.charBuffer);
        LongArrayPool.recycleArray(this.infoArray);
        this.pool.release();
        this.maxIndex = -1;
        this.recycled = true;
    }

    private void parseBuffer() {
        long existFlag = 0L;
        long[] existFlags = null;
        if (this.infoArray == null) {
            this.infoArray = LongArrayPool.getDefaultArray();
        }
        while (this.buffer.hasRemaining()) {
            byte type;
            int index;
            byte tag = this.buffer.readByte();
            int n = index = (tag & 0xFFFFFF80) == 0 ? tag & 0xF : this.buffer.readByte() & 0xFF;
            if (index > this.maxIndex) {
                this.maxIndex = index;
            }
            if (index < 64) {
                existFlag |= 1L << index;
            } else {
                if (existFlags == null) {
                    existFlags = new long[4];
                }
                int n2 = index >> 6;
                existFlags[n2] = existFlags[n2] | 1L << (index & 0x3F);
            }
            if (index >= this.infoArray.length) {
                long[] oldArray = this.infoArray;
                this.infoArray = LongArrayPool.getArray(index + 1);
                System.arraycopy(oldArray, 0, this.infoArray, 0, oldArray.length);
                LongArrayPool.recycleArray(oldArray);
            }
            if ((type = (byte)(tag & 0x70)) <= 64) {
                if (type == 0) {
                    this.infoArray[index] = 0L;
                    continue;
                }
                if (type == 16) {
                    this.infoArray[index] = (long)this.buffer.readByte() & 0xFFL;
                    continue;
                }
                if (type == 32) {
                    this.infoArray[index] = (long)this.buffer.readShort() & 0xFFFFL;
                    continue;
                }
                if (type == 48) {
                    this.infoArray[index] = (long)this.buffer.readInt() & 0xFFFFFFFFL;
                    continue;
                }
                byte b8 = this.buffer.hb[this.buffer.position + 7];
                if ((b8 & 0xFFFFFF80) == 0) {
                    this.infoArray[index] = this.buffer.readLong();
                    continue;
                }
                this.infoArray[index] = (long)this.buffer.position | Long.MIN_VALUE;
                this.buffer.position += 8;
                continue;
            }
            int size = type == 80 ? this.buffer.readByte() & 0xFF : (type == 96 ? this.buffer.readShort() & 0xFFFF : this.buffer.readInt());
            this.infoArray[index] = (long)this.buffer.position << 32 | (long)size;
            this.buffer.position += size;
        }
        if (this.buffer.position != this.buffer.limit) {
            throw new IllegalArgumentException("invalid pack data");
        }
        if (this.maxIndex <= 0) {
            return;
        }
        if (this.maxIndex <= 63) {
            int bits = 63 - this.maxIndex;
            long flippedFlag = (existFlag ^ 0xFFFFFFFFFFFFFFFFL) << bits;
            if (flippedFlag == 0L) {
                return;
            }
            flippedFlag >>>= bits;
            int i = 0;
            do {
                if ((flippedFlag & 1L) != 0L) {
                    this.infoArray[i] = -1L;
                }
                ++i;
            } while ((flippedFlag >>>= 1) != 0L);
        } else {
            int i;
            for (i = 0; i < 64; ++i) {
                if ((existFlag & 1L) == 0L) {
                    this.infoArray[i] = -1L;
                }
                existFlag >>>= 1;
            }
            if (existFlags != null) {
                for (i = 64; i < this.maxIndex; ++i) {
                    if ((existFlags[i >> 6] & 1L << (i & 0x3F)) != 0L) continue;
                    this.infoArray[i] = -1L;
                }
            }
        }
    }

    private char[] getCharBuffer(int len) {
        if (this.pool.charBuffer == null) {
            DecoderPool.access$502(this.pool, CharArrayPool.getArray(len));
        } else if (this.pool.charBuffer.length < len) {
            CharArrayPool.recycleArray(this.pool.charBuffer);
            DecoderPool.access$502(this.pool, new char[len]);
        }
        return this.pool.charBuffer;
    }

    private long getInfo(int index) {
        this.checkState();
        if (this.maxIndex < 0) {
            this.parseBuffer();
        }
        if (index > this.maxIndex) {
            return -1L;
        }
        return this.infoArray[index];
    }

    public boolean contains(int index) {
        return this.getInfo(index) != -1L;
    }

    public boolean getBoolean(int index, boolean defValue) {
        long info = this.getInfo(index);
        return info == -1L ? defValue : info == 1L;
    }

    public boolean getBoolean(int index) {
        return this.getInfo(index) == 1L;
    }

    public byte getByte(int index, byte defValue) {
        long info = this.getInfo(index);
        return info == -1L ? defValue : (byte)info;
    }

    public byte getByte(int index) {
        return this.getByte(index, (byte)0);
    }

    public short getShort(int index, short defValue) {
        long info = this.getInfo(index);
        return info == -1L ? defValue : (short)info;
    }

    public short getShort(int index) {
        return this.getShort(index, (short)0);
    }

    public int getInt(int index, int defValue) {
        long info = this.getInfo(index);
        return info == -1L ? defValue : (int)info;
    }

    public int getInt(int index) {
        long info = this.getInfo(index);
        return info == -1L ? 0 : (int)info;
    }

    public long getLong(int index, long defValue) {
        long info = this.getInfo(index);
        if (info == -1L) {
            return defValue;
        }
        return info >= 0L ? info : this.buffer.readLong((int)(info & 0xFFFFFFFFL));
    }

    public long getLong(int index) {
        return this.getLong(index, 0L);
    }

    public float getFloat(int index, float defValue) {
        long info = this.getInfo(index);
        return info == -1L ? defValue : Float.intBitsToFloat((int)info);
    }

    public float getFloat(int index) {
        return this.getFloat(index, 0.0f);
    }

    public double getDouble(int index, double defValue) {
        long info = this.getInfo(index);
        if (info == -1L) {
            return defValue;
        }
        long x = info >= 0L ? info : this.buffer.readLong((int)(info & 0xFFFFFFFFL));
        return Double.longBitsToDouble(x);
    }

    public double getDouble(int index) {
        return this.getDouble(index, 0.0);
    }

    public String getString(int index, String defValue) {
        long info = this.getInfo(index);
        if (info == -1L) {
            return defValue;
        }
        int len = (int)(info & 0xFFFFFFFFL);
        if (len == 0) {
            return "";
        }
        int offset = (int)(info >>> 32);
        return this.decodeStr(offset, len);
    }

    public String getNotNullString(int index) {
        return this.getString(index, "");
    }

    public String getString(int index) {
        return this.getString(index, null);
    }

    private String decodeStr(int offset, int len) {
        char[] buf = this.getCharBuffer(len);
        byte[] src = this.buffer.hb;
        int i = offset;
        int j = 0;
        int limit = offset + len;
        while (i < limit) {
            byte b3;
            byte b2;
            byte b1;
            if ((b1 = src[i++]) > 0) {
                buf[j++] = (char)b1;
                continue;
            }
            if (b1 < -32) {
                b2 = src[i++];
                buf[j++] = (char)((b1 & 0x1F) << 6 | b2 & 0x3F);
                continue;
            }
            if (b1 < -16) {
                b2 = src[i++];
                b3 = src[i++];
                buf[j++] = (char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
                continue;
            }
            b2 = src[i++];
            b3 = src[i++];
            byte b4 = src[i++];
            int cp = (b1 & 7) << 18 | (b2 & 0x3F) << 12 | (b3 & 0x3F) << 6 | b4 & 0x3F;
            buf[j++] = (char)(55232 + (cp >>> 10));
            buf[j++] = (char)(56320 + (cp & 0x3FF));
        }
        if (i > limit) {
            throw new IllegalArgumentException("Invalid String");
        }
        return new String(buf, 0, j);
    }

    public <T> T getObject(int index, TypeAdapter<T> adapter) {
        return this.getObject(index, adapter, null);
    }

    public <T> T getObject(int index, TypeAdapter<T> adapter, T defValue) {
        long info = this.getInfo(index);
        if (info == -1L) {
            return defValue;
        }
        int offset = (int)(info >>> 32);
        int len = (int)(info & 0xFFFFFFFFL);
        PackDecoder decoder = this.pool.getDecoder(offset, len);
        T object = adapter.decode(decoder);
        this.pool.recycleDecoder(decoder);
        return object;
    }

    public boolean[] getBooleanArray(int index) {
        boolean[] a;
        long info = this.getInfo(index);
        if (info == -1L) {
            return null;
        }
        int len = (int)(info & 0xFFFFFFFFL);
        if (len == 0) {
            return new boolean[0];
        }
        this.buffer.position = (int)(info >>> 32);
        if (len == 1) {
            byte b = this.buffer.readByte();
            int n = (b & 0xFF) >>> 5;
            a = new boolean[n];
            for (int i = 0; i < n; ++i) {
                a[i] = (b & 1) != 0;
                b = (byte)(b >> 1);
            }
        } else {
            byte remain = this.buffer.readByte();
            if (remain >> 3 != 0) {
                throw new IllegalStateException("remain overflow");
            }
            int byteCount = len - 1;
            int n = (byteCount << 3) - (remain > 0 ? 8 - remain : 0);
            a = new boolean[n];
            for (int i = 0; i < n; i += 8) {
                int j = i;
                for (int b = this.buffer.readByte() & 0xFF; b != 0; b >>= 1) {
                    a[j++] = (b & 1) != 0;
                }
            }
        }
        return a;
    }

    public byte[] getByteArray(int index) {
        long info = this.getInfo(index);
        if (info == -1L) {
            return null;
        }
        this.buffer.position = (int)(info >>> 32);
        int len = (int)(info & 0xFFFFFFFFL);
        byte[] bytes = new byte[len];
        this.buffer.readBytes(bytes);
        return bytes;
    }

    private int setPosAndGetLen(long info, int mask) {
        this.buffer.position = (int)(info >>> 32);
        int len = (int)(info & 0xFFFFFFFFL);
        if ((len & mask) != 0) {
            throw new IllegalStateException("invalid array length");
        }
        return len;
    }

    public int[] getIntArray(int index) {
        long info = this.getInfo(index);
        if (info == -1L) {
            return null;
        }
        int n = this.setPosAndGetLen(info, 3) >> 2;
        return PackDecoder.wrapIntArray(this.buffer, n);
    }

    public long[] getLongArray(int index) {
        long info = this.getInfo(index);
        if (info == -1L) {
            return null;
        }
        int n = this.setPosAndGetLen(info, 7) >> 3;
        return PackDecoder.wrapLongArray(this.buffer, n);
    }

    public float[] getFloatArray(int index) {
        long info = this.getInfo(index);
        if (info == -1L) {
            return null;
        }
        int n = this.setPosAndGetLen(info, 3) >> 2;
        float[] value = new float[n];
        for (int i = 0; i < n; ++i) {
            value[i] = this.buffer.readFloat();
        }
        return value;
    }

    public double[] getDoubleArray(int index) {
        long info = this.getInfo(index);
        if (info == -1L) {
            return null;
        }
        int n = this.setPosAndGetLen(info, 7) >> 3;
        double[] value = new double[n];
        for (int i = 0; i < n; ++i) {
            value[i] = this.buffer.readDouble();
        }
        return value;
    }

    public String[] getStringArray(int index) {
        int n = this.getSize(index);
        if (n < 0) {
            return null;
        }
        String[] value = new String[n];
        for (int i = 0; i < n; ++i) {
            value[i] = this.takeString();
        }
        return value;
    }

    String takeString() {
        int len = this.buffer.readVarInt32();
        if (len < 0) {
            return null;
        }
        int offset = this.buffer.position;
        this.buffer.checkBound(offset, len);
        if (len == 0) {
            return "";
        }
        String str = this.decodeStr(offset, len);
        this.buffer.position += len;
        return str;
    }

    public <T> T[] getObjectArray(int index, TypeAdapter<T> adapter, T[] array) {
        List<T> list = this.getObjectList(index, adapter);
        return list == null ? null : list.toArray(array);
    }

    <T> T takeObject(TypeAdapter<T> adapter) {
        int a = this.buffer.readShort();
        if (a == -1) {
            return null;
        }
        int len = a >= 0 ? a : (a & Short.MAX_VALUE) << 16 | this.buffer.readShort() & 0xFFFF;
        int offset = this.buffer.position;
        this.buffer.checkBound(offset, len);
        PackDecoder decoder = this.pool.getDecoder(offset, len);
        T t = adapter.decode(decoder);
        this.pool.recycleDecoder(decoder);
        this.buffer.position += len;
        return t;
    }

    public List<Integer> getIntList(int index) {
        int[] a = this.getIntArray(index);
        if (a == null) {
            return null;
        }
        int n = a.length;
        Integer[] b = new Integer[n];
        for (int i = 0; i < n; ++i) {
            b[i] = a[i];
        }
        return Arrays.asList(b);
    }

    public List<Long> getLongList(int index) {
        long[] a = this.getLongArray(index);
        if (a == null) {
            return null;
        }
        int n = a.length;
        Long[] b = new Long[n];
        for (int i = 0; i < n; ++i) {
            b[i] = a[i];
        }
        return Arrays.asList(b);
    }

    public List<Float> getFloatList(int index) {
        float[] a = this.getFloatArray(index);
        if (a == null) {
            return null;
        }
        int n = a.length;
        Float[] b = new Float[n];
        for (int i = 0; i < n; ++i) {
            b[i] = Float.valueOf(a[i]);
        }
        return Arrays.asList(b);
    }

    public List<Double> getDoubleList(int index) {
        double[] a = this.getDoubleArray(index);
        if (a == null) {
            return null;
        }
        int n = a.length;
        Double[] b = new Double[n];
        for (int i = 0; i < n; ++i) {
            b[i] = a[i];
        }
        return Arrays.asList(b);
    }

    public <T> List<T> getObjectList(int index, TypeAdapter<T> adapter) {
        int n = this.getSize(index);
        if (n < 0) {
            return null;
        }
        ArrayList<T> value = new ArrayList<T>(n);
        for (int i = 0; i < n; ++i) {
            value.add(this.takeObject(adapter));
        }
        return value;
    }

    public List<String> getStringList(int index) {
        String[] a = this.getStringArray(index);
        return a == null ? null : Arrays.asList(a);
    }

    int getSize(int index) {
        long info = this.getInfo(index);
        if (info == -1L) {
            return -1;
        }
        int len = (int)(info & 0xFFFFFFFFL);
        if (len == 0) {
            return 0;
        }
        this.buffer.position = (int)(info >>> 32);
        int n = this.buffer.readVarInt32();
        if (n < 0 || n > PackConfig.maxObjectArraySize) {
            throw new IllegalStateException("invalid size of object array");
        }
        return n;
    }

    public <K, V> Map<K, V> getMap(int index, Class<K> keyType, Class<V> valueType) {
        return this.getMap(index, keyType, valueType, null, null);
    }

    public <K, V> Map<K, V> getMap(int index, Class<K> keyType, Class<V> valueType, TypeAdapter<K> keyTypeAdapter, TypeAdapter<V> valueTypeAdapter) {
        int n = this.getSize(index);
        if (n < 0) {
            return null;
        }
        int initCapacity = (n << 2) / 3 + 1;
        HashMap<K, V> map = new HashMap<K, V>(initCapacity);
        for (int i = 0; i < n; ++i) {
            Object value;
            Object key;
            if (keyTypeAdapter != null) {
                key = this.takeObject(keyTypeAdapter);
            } else if (keyType == String.class) {
                key = this.takeString();
            } else if (keyType == Integer.class) {
                key = this.buffer.readInt();
            } else if (keyType == Long.class) {
                key = this.buffer.readLong();
            } else {
                if (PackConfig.ignoreUnknownType) {
                    return null;
                }
                String keyTypeName = keyType == null ? "null" : keyType.getSimpleName();
                throw new IllegalArgumentException("Unsupported type of key: " + keyTypeName);
            }
            if (valueTypeAdapter != null) {
                value = this.takeObject(valueTypeAdapter);
            } else if (valueType == String.class) {
                value = this.takeString();
            } else if (valueType == Integer.class) {
                value = this.buffer.readInt();
            } else if (valueType == Long.class) {
                value = this.buffer.readLong();
            } else if (valueType == Double.class) {
                value = this.buffer.readDouble();
            } else if (valueType == Float.class) {
                value = Float.valueOf(this.buffer.readFloat());
            } else if (valueType == Boolean.class) {
                value = this.buffer.readByte() == 1;
            } else {
                if (PackConfig.ignoreUnknownType) {
                    return null;
                }
                String valueTypeName = valueType == null ? "null" : valueType.getSimpleName();
                throw new IllegalArgumentException("Unsupported type of value: " + valueTypeName);
            }
            map.put(key, value);
        }
        return map;
    }

    static /* synthetic */ long[] access$302(PackDecoder x0, long[] x1) {
        x0.infoArray = x1;
        return x1;
    }

    private static class DecoderPool {
        private PackDecoder[] decoderArray;
        private int count = 0;
        private char[] charBuffer;
        final byte[] bytes;

        DecoderPool(byte[] bytes) {
            this.bytes = bytes;
        }

        private PackDecoder getDecoder(int offset, int len) {
            if (this.count > 0) {
                PackDecoder decoder = this.decoderArray[--this.count];
                this.decoderArray[this.count] = null;
                ((PackDecoder)decoder).buffer.position = offset;
                ((PackDecoder)decoder).buffer.limit = offset + len;
                decoder.maxIndex = -1;
                return decoder;
            }
            return new PackDecoder(new DecodeBuffer(this.bytes, offset, len), this);
        }

        private void recycleDecoder(PackDecoder decoder) {
            if (this.count >= 8) {
                LongArrayPool.recycleArray(decoder.infoArray);
                PackDecoder.access$302(decoder, null);
                decoder.recycled = true;
                decoder.maxIndex = -1;
                return;
            }
            if (this.decoderArray == null) {
                this.decoderArray = new PackDecoder[8];
            }
            this.decoderArray[this.count++] = decoder;
        }

        private void release() {
            for (int i = 0; i < this.count; ++i) {
                PackDecoder decoder = this.decoderArray[i];
                LongArrayPool.recycleArray(decoder.infoArray);
                this.decoderArray[i] = null;
            }
            this.decoderArray = null;
        }

        static /* synthetic */ char[] access$502(DecoderPool x0, char[] x1) {
            x0.charBuffer = x1;
            return x1;
        }
    }
}

