/*
 * Decompiled with CFR 0.152.
 */
package io.packable;

import io.packable.ByteArrayPool;
import io.packable.EncodeBuffer;
import io.packable.PackConfig;
import io.packable.TypeAdapter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class PackEncoder {
    private static final byte ZERO = 0;
    private static final byte ONE = 1;
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private static final String NOT_SUPPORT_EMPTY_ELEMENT = "not support empty element";
    private final EncodeBuffer buffer;
    private boolean allASCII = true;
    private boolean recycled = false;

    public PackEncoder() {
        byte[] array = ByteArrayPool.getArray();
        this.buffer = new EncodeBuffer(array);
    }

    public static <T> byte[] encode(T target, TypeAdapter<T> adapter) {
        PackEncoder encoder = new PackEncoder();
        adapter.encode(encoder, target);
        return encoder.toBytes();
    }

    public static <T> byte[] encodeObjectList(List<T> value, TypeAdapter<T> adapter) {
        if (value.isEmpty()) {
            return EMPTY_ARRAY;
        }
        PackEncoder encoder = new PackEncoder();
        encoder.buffer.writeVarInt32(value.size());
        for (T e : value) {
            encoder.wrapObject(e, adapter);
        }
        return encoder.toBytes();
    }

    public static byte[] encodeIntArray(int[] value) {
        if (value == null || value.length == 0) {
            return EMPTY_ARRAY;
        }
        PackEncoder encoder = new PackEncoder();
        int totalSize = EncodeBuffer.getVarInt32Size(value.length) + value.length * 4;
        encoder.buffer.checkCapacity(totalSize);
        encoder.buffer.writeVarInt32(value.length);
        for (int e : value) {
            encoder.buffer.writeInt(e);
        }
        return encoder.toBytes();
    }

    public static byte[] encodeLongArray(long[] value) {
        if (value == null || value.length == 0) {
            return EMPTY_ARRAY;
        }
        PackEncoder encoder = new PackEncoder();
        int totalSize = EncodeBuffer.getVarInt32Size(value.length) + value.length * 8;
        encoder.buffer.checkCapacity(totalSize);
        encoder.buffer.writeVarInt32(value.length);
        for (long e : value) {
            encoder.buffer.writeLong(e);
        }
        return encoder.toBytes();
    }

    public static byte[] encodeStringList(List<String> value) {
        if (value == null || value.isEmpty()) {
            return EMPTY_ARRAY;
        }
        PackEncoder encoder = new PackEncoder();
        encoder.buffer.writeVarInt32(value.size());
        for (String e : value) {
            encoder.wrapString(e);
        }
        return encoder.toBytes();
    }

    public byte[] toBytes() {
        this.checkBufferState();
        byte[] bytes = Arrays.copyOf(this.buffer.hb, this.buffer.position);
        this.recycle();
        return bytes;
    }

    private void recycle() {
        this.checkBufferState();
        ByteArrayPool.recycleArray(this.buffer.hb);
        this.buffer.hb = null;
        this.recycled = true;
    }

    private void checkBufferState() {
        if (this.recycled) {
            throw new IllegalStateException("Encoder had been recycled");
        }
    }

    private void putIndex(int index) {
        if (index >= 16) {
            this.buffer.writeByte((byte)-128);
        }
        this.buffer.writeByte((byte)index);
    }

    public PackEncoder putByte(int index, byte value) {
        this.buffer.checkCapacity(3);
        if (value == 0) {
            this.putIndex(index);
        } else {
            if (index < 16) {
                this.buffer.writeByte((byte)(index | 0x10));
            } else {
                this.buffer.writeByte((byte)-112);
                this.buffer.writeByte((byte)index);
            }
            this.buffer.writeByte(value);
        }
        return this;
    }

    public PackEncoder putBoolean(int index, boolean value) {
        return this.putByte(index, value ? (byte)1 : 0);
    }

    public PackEncoder putShort(int index, short value) {
        this.buffer.checkCapacity(4);
        if (value == 0) {
            this.putIndex(index);
        } else {
            int pos = this.buffer.position;
            this.putIndex(index);
            if (value >> 8 == 0) {
                int n = pos;
                this.buffer.hb[n] = (byte)(this.buffer.hb[n] | 0x10);
                this.buffer.writeByte((byte)value);
            } else {
                int n = pos;
                this.buffer.hb[n] = (byte)(this.buffer.hb[n] | 0x20);
                this.buffer.writeShort(value);
            }
        }
        return this;
    }

    public PackEncoder putInt(int index, int value) {
        this.buffer.checkCapacity(6);
        if (value == 0) {
            this.putIndex(index);
        } else {
            int pos = this.buffer.position;
            this.putIndex(index);
            if (value >> 8 == 0) {
                int n = pos;
                this.buffer.hb[n] = (byte)(this.buffer.hb[n] | 0x10);
                this.buffer.writeByte((byte)value);
            } else if (value >> 16 == 0) {
                int n = pos;
                this.buffer.hb[n] = (byte)(this.buffer.hb[n] | 0x20);
                this.buffer.writeShort((short)value);
            } else {
                int n = pos;
                this.buffer.hb[n] = (byte)(this.buffer.hb[n] | 0x30);
                this.buffer.writeInt(value);
            }
        }
        return this;
    }

    public PackEncoder putLong(int index, long value) {
        this.buffer.checkCapacity(10);
        if (value == 0L) {
            this.putIndex(index);
        } else {
            int pos = this.buffer.position;
            this.putIndex(index);
            if (value >> 32 != 0L) {
                int n = pos;
                this.buffer.hb[n] = (byte)(this.buffer.hb[n] | 0x40);
                this.buffer.writeLong(value);
            } else if (value >> 8 == 0L) {
                int n = pos;
                this.buffer.hb[n] = (byte)(this.buffer.hb[n] | 0x10);
                this.buffer.writeByte((byte)value);
            } else if (value >> 16 == 0L) {
                int n = pos;
                this.buffer.hb[n] = (byte)(this.buffer.hb[n] | 0x20);
                this.buffer.writeShort((short)value);
            } else {
                int n = pos;
                this.buffer.hb[n] = (byte)(this.buffer.hb[n] | 0x30);
                this.buffer.writeInt((int)value);
            }
        }
        return this;
    }

    public PackEncoder putFloat(int index, float value) {
        this.buffer.checkCapacity(6);
        if (value == 0.0f) {
            this.putIndex(index);
        } else {
            if (index < 16) {
                this.buffer.writeByte((byte)(index | 0x30));
            } else {
                this.buffer.writeByte((byte)-80);
                this.buffer.writeByte((byte)index);
            }
            this.buffer.writeFloat(value);
        }
        return this;
    }

    public PackEncoder putDouble(int index, double value) {
        this.buffer.checkCapacity(10);
        if (value == 0.0) {
            this.putIndex(index);
        } else {
            if (index < 16) {
                this.buffer.writeByte((byte)(index | 0x40));
            } else {
                this.buffer.writeByte((byte)-64);
                this.buffer.writeByte((byte)index);
            }
            this.buffer.writeDouble(value);
        }
        return this;
    }

    public PackEncoder putString(int index, String value) {
        if (value == null) {
            return this;
        }
        if (value.isEmpty()) {
            this.buffer.checkCapacity(2);
            this.putIndex(index);
            return this;
        }
        int n = value.length();
        if (n <= 85) {
            this.buffer.checkCapacity(258);
            int pos = this.buffer.position;
            this.putIndex(index);
            int n2 = pos;
            this.buffer.hb[n2] = (byte)(this.buffer.hb[n2] | 0x50);
            pos = this.buffer.position++;
            this.encodeStr(value);
            this.buffer.hb[pos] = (byte)(this.buffer.position - pos - 1);
        } else {
            if (this.allASCII && !this.isAllASCII(value)) {
                this.allASCII = false;
            }
            if (this.allASCII) {
                this.wrapTagAndLength(index, n);
                value.getBytes(0, n, this.buffer.hb, this.buffer.position);
                this.buffer.position += n;
            } else {
                byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
                this.wrapTagAndLength(index, bytes.length);
                this.buffer.writeBytes(bytes);
            }
        }
        return this;
    }

    private void wrapString(String str) {
        if (str == null) {
            this.buffer.checkCapacity(5);
            this.buffer.writeVarIntNegative1();
        } else {
            int n = str.length();
            if (n == 0) {
                this.buffer.checkCapacity(1);
                this.buffer.hb[this.buffer.position++] = 0;
                return;
            }
            int sizeOfLen = EncodeBuffer.getVarInt32Size(n);
            int pLen = this.buffer.position;
            this.buffer.position += sizeOfLen;
            this.buffer.checkCapacity(n * 3);
            int start = this.buffer.position;
            this.encodeStr(str);
            int len = this.buffer.position - start;
            int realSizeOfLen = EncodeBuffer.getVarInt32Size(len);
            if (realSizeOfLen != sizeOfLen) {
                int diff = realSizeOfLen - sizeOfLen;
                this.buffer.checkCapacity(diff);
                System.arraycopy(this.buffer.hb, start, this.buffer.hb, start + diff, len);
                this.buffer.position += diff;
            }
            this.buffer.writeVarInt32(pLen, len);
        }
    }

    private boolean isAllASCII(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (s.charAt(i) < '\u0080') continue;
            return false;
        }
        return true;
    }

    private void encodeStr(String s) {
        byte[] buf = this.buffer.hb;
        int j = this.buffer.position;
        int i = 0;
        int n = s.length();
        while (i < n) {
            char c;
            if ((c = s.charAt(i++)) < '\u0080') {
                buf[j++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                buf[j++] = (byte)(0xC0 | c >>> 6);
                buf[j++] = (byte)(0x80 | 0x3F & c);
                continue;
            }
            if (c < '\ud800' || c > '\udfff') {
                buf[j++] = (byte)(0xE0 | c >>> 12);
                buf[j++] = (byte)(0x80 | 0x3F & c >>> 6);
                buf[j++] = (byte)(0x80 | 0x3F & c);
                continue;
            }
            char c2 = s.charAt(i++);
            int cp = Character.toCodePoint(c, c2);
            buf[j++] = (byte)(0xF0 | cp >>> 18);
            buf[j++] = (byte)(0x80 | 0x3F & cp >>> 12);
            buf[j++] = (byte)(0x80 | 0x3F & cp >>> 6);
            buf[j++] = (byte)(0x80 | 0x3F & cp);
        }
        this.buffer.position = j;
    }

    public <T> PackEncoder putObject(int index, T value, TypeAdapter<T> adapter) {
        if (value == null) {
            return this;
        }
        this.buffer.checkCapacity(6);
        int pTag = this.buffer.position;
        this.putIndex(index);
        this.buffer.position += 4;
        int pValue = this.buffer.position;
        adapter.encode(this, value);
        if (pValue == this.buffer.position) {
            this.buffer.position -= 4;
        } else {
            this.putLen(pTag, pValue);
        }
        return this;
    }

    private long wrapObjectArrayHeader(int index, int size) {
        if (size > PackConfig.maxObjectArraySize) {
            throw new IllegalStateException("object array size out of limit");
        }
        this.buffer.checkCapacity(11);
        long pTag = this.buffer.position;
        this.putIndex(index);
        if (size <= 0) {
            return -1L;
        }
        this.buffer.position += 4;
        long pValue = this.buffer.position;
        this.buffer.writeVarInt32(size);
        return pTag << 32 | pValue;
    }

    public PackEncoder putStringArray(int index, String[] value) {
        if (value == null) {
            return this;
        }
        long tagValue = this.wrapObjectArrayHeader(index, value.length);
        if (tagValue < 0L) {
            return this;
        }
        for (String str : value) {
            this.wrapString(str);
        }
        this.putLen((int)(tagValue >>> 32), (int)tagValue);
        return this;
    }

    public <T> PackEncoder putObjectArray(int index, T[] value, TypeAdapter<T> adapter) {
        if (value == null) {
            return this;
        }
        long tagValue = this.wrapObjectArrayHeader(index, value.length);
        if (tagValue < 0L) {
            return this;
        }
        for (T e : value) {
            this.wrapObject(e, adapter);
        }
        this.putLen((int)(tagValue >>> 32), (int)tagValue);
        return this;
    }

    private <T> void wrapObject(T target, TypeAdapter<T> adapter) {
        this.buffer.checkCapacity(2);
        if (target == null) {
            this.buffer.writeShort((short)-1);
        } else {
            int pLen = this.buffer.position;
            this.buffer.position += 2;
            int pObj = this.buffer.position;
            adapter.encode(this, target);
            int len = this.buffer.position - pObj;
            if (len <= Short.MAX_VALUE) {
                this.buffer.writeShort(pLen, (short)len);
            } else {
                this.buffer.checkCapacity(2);
                System.arraycopy(this.buffer.hb, pObj, this.buffer.hb, pObj + 2, len);
                this.buffer.position += 2;
                this.buffer.writeShort(pLen, (short)(len >>> 16 | 0x8000));
                this.buffer.writeShort(pLen + 2, (short)len);
            }
        }
    }

    private void putLen(int pTag, int pValue) {
        int len = this.buffer.position - pValue;
        if (len <= 128) {
            int n = pTag;
            this.buffer.hb[n] = (byte)(this.buffer.hb[n] | 0x50);
            this.buffer.hb[pValue - 4] = (byte)len;
            System.arraycopy(this.buffer.hb, pValue, this.buffer.hb, pValue - 3, len);
            this.buffer.position -= 3;
        } else {
            int n = pTag;
            this.buffer.hb[n] = (byte)(this.buffer.hb[n] | 0x70);
            this.buffer.writeInt(pValue - 4, len);
        }
    }

    public PackEncoder putBooleanArray(int index, boolean[] value) {
        if (value == null) {
            return this;
        }
        int n = value.length;
        if (n == 0) {
            this.wrapTagAndLength(index, 0);
            return this;
        }
        if (n <= 5) {
            byte b = (byte)(n << 5);
            for (int i = 0; i < n; ++i) {
                if (!value[i]) continue;
                b = (byte)(b | 1 << i);
            }
            this.wrapTagAndLength(index, 1);
            this.buffer.writeByte(b);
        } else {
            int remain = n & 7;
            int byteCount = (n >> 3) + (remain == 0 ? 1 : 2);
            this.wrapTagAndLength(index, byteCount);
            this.buffer.writeByte((byte)remain);
            int i = 0;
            while (i < n) {
                int end = Math.min(i + 8, n);
                byte b = 0;
                for (int j = i; j < end; ++j) {
                    if (!value[j]) continue;
                    b = (byte)(b | 1 << (j & 7));
                }
                this.buffer.writeByte(b);
                i = end;
            }
        }
        return this;
    }

    public PackEncoder putByteArray(int index, byte[] value) {
        if (value != null) {
            this.wrapTagAndLength(index, value.length);
            this.buffer.writeBytes(value);
        }
        return this;
    }

    public PackEncoder putIntArray(int index, int[] value) {
        if (value != null) {
            this.wrapTagAndLength(index, value.length << 2);
            for (int e : value) {
                this.buffer.writeInt(e);
            }
        }
        return this;
    }

    public PackEncoder putLongArray(int index, long[] value) {
        if (value != null) {
            this.wrapTagAndLength(index, value.length << 3);
            for (long e : value) {
                this.buffer.writeLong(e);
            }
        }
        return this;
    }

    public PackEncoder putFloatArray(int index, float[] value) {
        if (value != null) {
            this.wrapTagAndLength(index, value.length << 2);
            for (float e : value) {
                this.buffer.writeFloat(e);
            }
        }
        return this;
    }

    public PackEncoder putDoubleArray(int index, double[] value) {
        if (value != null) {
            this.wrapTagAndLength(index, value.length << 3);
            for (double e : value) {
                this.buffer.writeDouble(e);
            }
        }
        return this;
    }

    void wrapTagAndLength(int index, int len) {
        this.buffer.checkCapacity(6 + len);
        if (len == 0) {
            this.putIndex(index);
        } else {
            int pos = this.buffer.position;
            this.putIndex(index);
            if (len <= 255) {
                int n = pos;
                this.buffer.hb[n] = (byte)(this.buffer.hb[n] | 0x50);
                this.buffer.writeByte((byte)len);
            } else if (len <= 65535) {
                int n = pos;
                this.buffer.hb[n] = (byte)(this.buffer.hb[n] | 0x60);
                this.buffer.writeShort((short)len);
            } else {
                int n = pos;
                this.buffer.hb[n] = (byte)(this.buffer.hb[n] | 0x70);
                this.buffer.writeInt(len);
            }
        }
    }

    int getListSize(int index, Collection<?> value) {
        if (value == null) {
            return 0;
        }
        if (value.isEmpty()) {
            this.wrapTagAndLength(index, 0);
            return 0;
        }
        return value.size();
    }

    public PackEncoder putIntList(int index, Collection<Integer> value) {
        int n = this.getListSize(index, value);
        if (n <= 0) {
            return this;
        }
        int[] a = new int[n];
        int i = 0;
        for (Integer x : value) {
            if (x == null) {
                throw new IllegalArgumentException(NOT_SUPPORT_EMPTY_ELEMENT);
            }
            a[i++] = x;
        }
        this.putIntArray(index, a);
        return this;
    }

    public PackEncoder putLongList(int index, Collection<Long> value) {
        int n = this.getListSize(index, value);
        if (n <= 0) {
            return this;
        }
        long[] a = new long[n];
        int i = 0;
        for (Long x : value) {
            if (x == null) {
                throw new IllegalArgumentException(NOT_SUPPORT_EMPTY_ELEMENT);
            }
            a[i++] = x;
        }
        this.putLongArray(index, a);
        return this;
    }

    public PackEncoder putFloatList(int index, Collection<Float> value) {
        int n = this.getListSize(index, value);
        if (n <= 0) {
            return this;
        }
        float[] a = new float[n];
        int i = 0;
        for (Float x : value) {
            if (x == null) {
                throw new IllegalArgumentException(NOT_SUPPORT_EMPTY_ELEMENT);
            }
            a[i++] = x.floatValue();
        }
        this.putFloatArray(index, a);
        return this;
    }

    public PackEncoder putDoubleList(int index, Collection<Double> value) {
        int n = this.getListSize(index, value);
        if (n <= 0) {
            return this;
        }
        double[] a = new double[n];
        int i = 0;
        for (Double x : value) {
            if (x == null) {
                throw new IllegalArgumentException(NOT_SUPPORT_EMPTY_ELEMENT);
            }
            a[i++] = x;
        }
        this.putDoubleArray(index, a);
        return this;
    }

    public <T> PackEncoder putObjectList(int index, Collection<? extends T> value, TypeAdapter<T> adapter) {
        if (value == null) {
            return this;
        }
        int size = value.size();
        long tagValue = this.wrapObjectArrayHeader(index, size);
        if (tagValue < 0L) {
            return this;
        }
        for (T e : value) {
            this.wrapObject(e, adapter);
        }
        this.putLen((int)(tagValue >>> 32), (int)tagValue);
        return this;
    }

    public PackEncoder putStringList(int index, Collection<String> value) {
        if (value == null) {
            return this;
        }
        long tagValue = this.wrapObjectArrayHeader(index, value.size());
        if (tagValue < 0L) {
            return this;
        }
        for (String str : value) {
            this.wrapString(str);
        }
        this.putLen((int)(tagValue >>> 32), (int)tagValue);
        return this;
    }

    public <K, V> PackEncoder putMap(int index, Map<K, V> map) {
        return this.putMap(index, map, null, null);
    }

    public <K, V> PackEncoder putMap(int index, Map<K, V> map, TypeAdapter<V> valueTypeAdapter) {
        return this.putMap(index, map, null, valueTypeAdapter);
    }

    public <K, V> PackEncoder putMap(int index, Map<K, V> map, TypeAdapter<K> keyAdapter, TypeAdapter<V> valueAdapter) {
        if (map == null) {
            return this;
        }
        map.entrySet().removeIf(entry -> entry.getKey() == null || entry.getValue() == null);
        int size = map.size();
        if (size != 0) {
            Class<?> type;
            Class<?> keyType = null;
            Class<?> valueType = null;
            Map.Entry<K, V> entry2 = map.entrySet().iterator().next();
            if (keyAdapter == null) {
                type = entry2.getKey().getClass();
                if (!map.keySet().stream().allMatch(key -> key.getClass() == type)) {
                    throw new IllegalArgumentException("The key not support multiply types");
                }
                keyType = type;
            }
            if (valueAdapter == null) {
                type = entry2.getValue().getClass();
                if (!map.values().stream().allMatch(value -> value.getClass() == type)) {
                    throw new IllegalArgumentException("The value not support multiply types");
                }
                valueType = type;
            }
            return this.putMap(index, map, keyType, valueType, keyAdapter, valueAdapter);
        }
        this.wrapObjectArrayHeader(index, size);
        return this;
    }

    public <K, V> PackEncoder putMap(int index, Map<K, V> map, Class<K> keyType, Class<V> valueType, TypeAdapter<K> keyAdapter, TypeAdapter<V> valueAdapter) {
        if (map == null) {
            return this;
        }
        int size = map.size();
        long tagValue = this.wrapObjectArrayHeader(index, size);
        if (tagValue < 0L) {
            return this;
        }
        int mark = this.buffer.position;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (keyAdapter != null) {
                this.wrapObject(entry.getKey(), keyAdapter);
            } else if (keyType == String.class) {
                this.wrapString((String)entry.getKey());
            } else {
                K key = entry.getKey();
                if (key == null) continue;
                this.buffer.checkCapacity(8);
                if (keyType == Integer.class) {
                    this.buffer.writeInt((Integer)key);
                } else if (keyType == Long.class) {
                    this.buffer.writeLong((Long)key);
                } else {
                    if (PackConfig.ignoreUnknownType) {
                        this.buffer.position = mark;
                        return this;
                    }
                    String keyTypeName = keyType == null ? "null" : keyType.getSimpleName();
                    throw new IllegalArgumentException("Unsupported type of key: " + keyTypeName);
                }
            }
            if (valueAdapter != null) {
                this.wrapObject(entry.getValue(), valueAdapter);
                continue;
            }
            if (valueType == String.class) {
                this.wrapString((String)entry.getValue());
                continue;
            }
            V value = entry.getValue();
            if (value == null) {
                throw new IllegalArgumentException("The values is null");
            }
            this.buffer.checkCapacity(8);
            if (valueType == Integer.class) {
                this.buffer.writeInt((Integer)value);
                continue;
            }
            if (valueType == Long.class) {
                this.buffer.writeLong((Long)value);
                continue;
            }
            if (valueType == Double.class) {
                this.buffer.writeDouble((Double)value);
                continue;
            }
            if (valueType == Float.class) {
                this.buffer.writeFloat(((Float)value).floatValue());
                continue;
            }
            if (valueType == Boolean.class) {
                this.buffer.writeByte((Boolean)value != false ? (byte)1 : 0);
                continue;
            }
            if (PackConfig.ignoreUnknownType) {
                this.buffer.position = mark;
                return this;
            }
            String valueTypeName = valueType == null ? "null" : valueType.getSimpleName();
            throw new IllegalArgumentException("Unsupported type of value: " + valueTypeName);
        }
        this.putLen((int)(tagValue >>> 32), (int)tagValue);
        return this;
    }
}

