/*
 * Decompiled with CFR 0.152.
 */
package io.github.codejanovic.java.filesearch;

import io.github.codejanovic.java.filesearch.FileSearch;
import java.io.File;
import java.nio.file.Path;
import java.util.Optional;

public class Search {
    private Optional<File> directory = Optional.empty();
    private boolean recursively = false;

    public static Search search() {
        return new Search();
    }

    public Search directory(File file) {
        this.directory = Optional.of(file);
        return this;
    }

    public Search directory(Path path) {
        this.directory = Optional.of(path.toFile());
        return this;
    }

    public Search directory(String path) {
        this.directory = Optional.of(new File(path));
        return this;
    }

    public Search recursively() {
        this.recursively = true;
        return this;
    }

    public Search notRecursively() {
        this.recursively = false;
        return this;
    }

    public FileSearch<File> byFile() {
        return this.recursively ? new FileSearch.ByFileRecursive(this.directory.get()) : new FileSearch.ByFile(this.directory.get());
    }

    public FileSearch<Path> byPath() {
        return this.recursively ? new FileSearch.ByPathRecursive(this.directory.get()) : new FileSearch.ByPath(this.directory.get());
    }
}

